// File for Make the tree file from anapaw.
// Author: Yasuhiro Togano
// 10/05/13

#ifndef MAKETREE_H
#define MAKETREE_H

#include <stdio.h>
#include <vector>
#include <TFile.h>
#include <TTree.h>

#include "TMust2Data.h"
#include "TSSSDData.h"

// Common block storing the Focal plane information
extern "C" {
  extern struct {
    float fpdata[12][5][6]; //[nfocus][datatype][nfpdata]
    int lfpdata[12][5][7];
  } focalplanedata_;
}

// Common block storing the MUST2 information
extern "C" {
  extern struct{
    int multinm2[8][4];//[MUST2ID][Dettype]
    int m2dtype[2304][3];
    float m2data[8][4][3][128]; //[MUST2ID][Dettype][ID,E,T][mult]
  } must2conf_;
}

// Common block storing the run number.
extern "C" {
  extern struct {
    int rnumber;
  } anarunstat_;
}

// Common block that stores the 20um data
extern "C" {
  extern struct {
    float ssdenergy[64] ;
  } ssdtree_;
}

// Common block storing the PPAC, TOF, and AoQ
extern "C"{
  extern struct{
    float ppacdata[5][5];
    float tofdata[20];
    float aoqdata[20][4];
    int notof;
    int noaoq;
    //    int trig[16];
    int gatconf;
    float mm_left_plf7;
    float mm_left_ppac;
    float ppacdataf5[5][5];
  } fortree_;
}

extern "C"{
  void open_treefile__(char name[132], int* fnamelen, int* flag);
  void close_treefile__();
  void add_event2tree__();
}

class MakeTree{
private:
  TFile *fOutFile;
  TTree *t1;
  bool fIsInitialized;
  static MakeTree *fgMakeTree;
  int fPrevRunNumber;

  //Variables for the Branch store
  //for BEAMLINE
  float tPosition[12][4], tTime[12][6], tdE[12][3], tE[12][3];

  //for MUST2
  TMust2Data* Must2Data;

  // for PPAC, TOF, AoQ
  float tPPAC[5][5], tTOF[20], tAoQ[20][4];
  int tNoTOF, tNoAoQ;
  float tPPACF5[5][5];

  // run rumber
  int tRunNumber;
  
  // event number;
  int tEventNumber;

  // 20 um silicons
  TSSSDData *SSSDData ;

  int tTrig[16];
  int tGATCONF;
  float tMM_LEFT_PLF7, tMM_LEFT_PPAC;

public:
  MakeTree();
  ~MakeTree();
  static MakeTree *Instance();
  int Open(const char *filename = 0);
  inline TFile* GetOutFilePtr() const {return fOutFile;};
  inline TTree* GetTTreePtr() const {return t1;};

  void Initialize();
  void BeginOfRun();
  void AddEvent();
  void GetEvent();
  void ClearEvent();
  void Clear();
  void EndOfRun();
};


#endif

