// File for Make the tree file from anapaw.
// Author: Yasuhiro Togano
// 10/05/13
// kieta

#include "MakeTree.h"
#include <cstdlib>
#include <sstream>
#include <iostream>

//#include <iostream>

MakeTree *MakeTree::fgMakeTree = 0;

MakeTree::MakeTree()
  : fIsInitialized(false)
{
}

MakeTree::~MakeTree()
{
}

void MakeTree::Initialize(){
  if(fIsInitialized) return;
  
  fgMakeTree -> ClearEvent();
  fIsInitialized = true;
}

MakeTree* MakeTree::Instance(){
  if(!fgMakeTree) fgMakeTree = new MakeTree();
  return fgMakeTree;
}

// Initialize root file and Tree
void MakeTree::BeginOfRun(){

  t1 -> Branch("RunNumber",&tRunNumber,"RunNumber/I");
  t1 -> Branch("EventNumber",&tEventNumber,"EventNumber/I");

  //  t1 -> Branch("Trig",tTrig,"Trig[16]/I");

  t1 -> Branch("GATCONF",&tGATCONF,"GATCONF/I");
  t1 -> Branch("MM_LEFT_PLF7",&tMM_LEFT_PLF7,"MM_LEFT_PLF7/F");
  t1 -> Branch("MM_LEFT_PPAC",&tMM_LEFT_PPAC,"MM_LEFT_PPAC/F");

  //Define and initalize Branches
  // Position of particles @F0-F11
  t1 -> Branch("FPPosition",tPosition,"FPPosition[12][4]/F");
  // Timing of plastic scintillator@F0-F11
  t1 -> Branch("FPTime",tTime,"FPTime[12][6]/F");
  // dE 
  t1 -> Branch("FPdE",tdE,"FPdE[12][3]/F");
  // E
  //  t1 -> Branch("FPE",tE,"FPE[12][3]/F");

  // for MUST2 vector
  Must2Data = new TMust2Data();
  t1-> Branch("MUST2",&Must2Data);

  // t1-> Branch("NoTOF",&tNoTOF,"NoTOF/I");
  // t1-> Branch("NoAoQ",&tNoAoQ,"NoAoQ/I");
  
  t1-> Branch("PPACF8",tPPAC,"PPACF8[5][5]/F");
  t1-> Branch("PPACF5",tPPACF5,"PPACF5[5][5]/F");

  //  ostringstream stof;
  //  stof << "TOF[" << tNoTOF <<"]/F";
  t1-> Branch("TOF", tTOF,"TOF[8]/F" );
  //  t1-> Branch("TOF", tTOF, "TOF[NoTOF]/F");

  //  ostringstream sAoQ;
  //  sAoQ << "AoQ[" << tNoAoQ <<"][4]/F";
  t1-> Branch("AoQ",tAoQ, "AoQ[9][4]");
  
  // 
  // for SSSD vector
  SSSDData = new TSSSDData() ;
  t1-> Branch("SSSD",&SSSDData);
 

}

int MakeTree::Open(const char *filename){
  //Make the root file 
  int ret;

  fOutFile = new TFile(filename,"NEW");
  
  if(fOutFile->IsZombie()){
    ret = 1;
    printf("file open status: ERROR\n");
  }
  else{
    printf("file open status: OK\n");
    t1 = new TTree("t1", filename);
    fgMakeTree -> BeginOfRun();  
    tEventNumber = 0;
    t1 -> SetAutoSave(10000000);
    ret = 0;

  }
  
  return ret;

}
  


// Add Events to Root file
void MakeTree::GetEvent(){

  tEventNumber++;
  tRunNumber = anarunstat_.rnumber;

  //  for(int i=0;i<16;i++){
  //    tTrig[i] = fortree_.trig[i];
  //  }

  tGATCONF = fortree_.gatconf;
  tMM_LEFT_PLF7 = fortree_.mm_left_plf7;
  tMM_LEFT_PPAC = fortree_.mm_left_ppac;


 
  // Store the event from the focal planes
  for(int i=0;i<12;i++){
    for(int j=0;j<4;j++){
      tPosition[i][j] = focalplanedata_.fpdata[i][0][j];
    }

    for(int j=0;j<6;j++){
      tTime[i][j] = focalplanedata_.fpdata[i][1][j];
    }

    for(int j=0;j<3;j++){
      tdE[i][j] = focalplanedata_.fpdata[i][2][j];
    }
    
    //    for(int j=0;j<3;j++){
    //      tE[i][j] = focalplanedata_.fpdata[i][3][j];
    //    }
  }
  // Store the event from MUST2
  for(int i=0;i<8;i++){ // MUST2ID loop
    for(int j=0;j<4;j++){ // MUST2 det type loop
      for(int k=0;k<must2conf_.multinm2[i][j];k++){ //multiplicity loop
	if(j == 0){
	  Must2Data->SetMMStripXEDetectorNbr(i+1);
	  Must2Data->SetMMStripXEStripNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMStripXEEnergy(must2conf_.m2data[i][j][1][k]);
	  Must2Data->SetMMStripXTDetectorNbr(i+1);
	  Must2Data->SetMMStripXTStripNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMStripXTTime(must2conf_.m2data[i][j][2][k]);
	}
	else if(j==1){
	  Must2Data->SetMMStripYEDetectorNbr(i+1);
	  Must2Data->SetMMStripYEStripNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMStripYEEnergy(must2conf_.m2data[i][j][1][k]);
	  Must2Data->SetMMStripYTDetectorNbr(i+1);
	  Must2Data->SetMMStripYTStripNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMStripYTTime(must2conf_.m2data[i][j][2][k]);
	}
	else if(j==2){
	  Must2Data->SetMMSiLiEDetectorNbr(i+1);
	  Must2Data->SetMMSiLiEPadNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMSiLiEEnergy(must2conf_.m2data[i][j][1][k]);
	  Must2Data->SetMMSiLiTDetectorNbr(i+1);
	  Must2Data->SetMMSiLiTPadNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMSiLiTTime(must2conf_.m2data[i][j][2][k]);
	}
	else if(j==3){
	  Must2Data->SetMMCsIEDetectorNbr(i+1);
	  Must2Data->SetMMCsIECristalNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMCsIEEnergy(must2conf_.m2data[i][j][1][k]);
	  Must2Data->SetMMCsITDetectorNbr(i+1);
	  Must2Data->SetMMCsITCristalNbr(must2conf_.m2data[i][j][0][k]);
	  Must2Data->SetMMCsITTime(must2conf_.m2data[i][j][2][k]);
	}
      }
    }
  }

  // Store the event from SSSD
  for(int i=0;i<64;i++){ // ADC loop
    if(ssdtree_.ssdenergy[i]>0){
      SSSDData->SetEnergy(ssdtree_.ssdenergy[i]);
      SSSDData->SetEnergyStripNbr(i%16+1);
      SSSDData->SetEnergyDetectorNbr(int(i/16)+1);
    }
  }

  tNoTOF = fortree_.notof;
  tNoAoQ = fortree_.noaoq;

  for(int i=0;i<5;i++){
    for(int j=0;j<5;j++){
      tPPAC[i][j] = fortree_.ppacdata[i][j];
      tPPACF5[i][j] = fortree_.ppacdataf5[i][j];
    }
  }

  for(int i=0;i<fortree_.notof;i++){
    tTOF[i] = fortree_.tofdata[i];
  }

  for(int i=0;i<fortree_.noaoq;i++){
    for(int j=0;j<4;j++){
      tAoQ[i][j] = fortree_.aoqdata[i][j];
    }
  }

  
}

void MakeTree::AddEvent(){
  
  fgMakeTree -> GetEvent();

  // Fill the event to tree
  t1 -> Fill();
    
  fgMakeTree -> ClearEvent();

}


void MakeTree::ClearEvent(){

  tRunNumber = 0;
  
  //  for(int i=0;i<16;i++){
  //    tTrig[i] = 0;
  //  }
  tMM_LEFT_PLF7 = -1000.;
  tMM_LEFT_PPAC = -1000.;


  // Clear all of the Branches
  for(int i=0;i<12;i++){
    for(int j=0;j<4;j++){
      tPosition[i][j] = -1000.;
    }

    for(int j=0;j<6;j++){
      tTime[i][j] = -1000.;
    }

    for(int j=0;j<3;j++){
      tdE[i][j] = -1000.;
    }
    
    for(int j=0;j<3;j++){
      tE[i][j] = -1000.;
    }
  }

  Must2Data -> Clear();
  SSSDData->Clear();

  tNoTOF = 0;
  tNoAoQ = 0;

  for(int i=0;i<5;i++){
    for(int j=0;j<5;j++){
      tPPAC[i][j] = -1000.;
      tPPACF5[i][j] = -1000.;
    }
  }

  for(int i=0;i<fortree_.notof;i++){
    tTOF[i] = -1000.;
  }

  for(int i=0;i<fortree_.noaoq;i++){
    for(int j=0;j<4;j++){
      tAoQ[i][j] = -1000.;
    }
  }


}

void MakeTree::Clear(){
  fIsInitialized = false;
}

 
void MakeTree::EndOfRun(){ 

  if(fOutFile -> IsOpen()){
    t1 -> Print();
    
    t1 -> Write();
    
    fOutFile -> Close();
    
    fgMakeTree -> Clear();
  }
  else{
    printf("Root file is not opened\n");
  }
}
 

//===========================================================================
// for fortran compatible
//===========================================================================
void open_treefile__(char name[132], int* fnamelen, int *flag){
  char filename[256];
  memset(filename, 0, sizeof(filename));
  strncpy(filename, name, *fnamelen);
  
  printf("opening treefile %s\n", name);
  
  MakeTree *make = MakeTree::Instance();
  *flag = make -> Open(filename);
}

void close_treefile__(){
  MakeTree::Instance() -> Initialize();
  MakeTree::Instance() -> EndOfRun();
}

void add_event2tree__(){
  MakeTree::Instance() -> Initialize();
  MakeTree::Instance() -> AddEvent();
}

//===========================================================================
//===========================================================================
