/* dumpdata.c
   Sep 5,2000  H.Baba (Rikkyo Univ.)
*/

#include <stdio.h>
#include <string.h>

static unsigned short ddata[0x2000];
int maxevt,blkidx,blkflag,mkhflag;
FILE *fd;

void open_dumpfile__(char name[132],int *fnamelen,int *flag,int *mx){
  char filename[132];

  maxevt = 0x2000 - *mx - 3;
  blkflag = 0;
  mkhflag = 0;

  memset(ddata,0,0x4000);
  memset(filename,0,132);
  memcpy(filename,name,*fnamelen);

  if((fd = fopen(filename,"r")) != NULL){
    fclose(fd);
    *flag = 1;
  }
  else
    { 
      fd = fopen(filename,"w");
      *flag = 0;
    }
}

void mkheader_dumpfile__(void){
  ddata[blkidx++] = 0xffff;
  ddata[blkidx++] = 0xffff;
  fwrite(ddata,2,0x2000,fd);
  blkflag = 0;
  mkhflag = 1;
}

void close_dumpfile__(void){
  if(mkhflag == 0){
    ddata[blkidx++] = 0xffff;
    ddata[blkidx++] = 0xffff;
    fwrite(ddata,2,0x2000,fd);
  }
  blkflag = 0;
  mkhflag = 0;
  fclose(fd);
}

void add_event__(unsigned short edata[],int *rnum){
  int esize,i;

  mkhflag = 0;

  if(blkflag == 0){
    blkidx = 0;
    ddata[blkidx] = 0;
    ddata[blkidx+1] = *rnum;
    for(blkidx=2;blkidx<4;blkidx++){
      ddata[blkidx] = 0;
    }
    blkflag = 1;
  }
  
  esize = edata[0] & 0x7fff;
  memcpy(ddata+blkidx,edata,2*esize);
  blkidx += esize;

  if(blkidx > maxevt){
    ddata[blkidx++] = 0xffff;
    ddata[blkidx++] = 0xffff;
    fwrite(ddata,2,0x2000,fd);
    blkflag = 0;
  }
}
