c =================================================================
      Subroutine XFITG

      Include 'common.f'

      Integer   FKIND,TLEN1,TLEN2
      Integer   BLNX,BXMIN,BXMAX,BLNY,BYMIN,BYMAX
      Real      TMPX1,TMPX2,TMPY1,TMPY2
      Real      BLXMIN,BLXMAX,BLYMIN,BLYMAX
      Integer   ISTAT,NT
      Character*4 OPTLGX
      Character KUCOMLINE*80,IDTEMP*5,CBMIN*132,CBMAX*132

      OPTLGX = 'LOGX'

      Call GETHPLOPT(OPTLGX)

      HID = DispID(DSeqID)

      Call HKIND(HID,FKIND,' ')

      If(FKIND.EQ.1) Then
         Call IRQLC(1,20,ISTAT,NT,TMPX1,TMPY1)
         Call IRQLC(1,20,ISTAT,NT,TMPX2,TMPY2)
         If(TMPX1.GT.TMPX2) Then
            BLXMIN = TMPX2
            BLXMAX = TMPX1
         Else
            BLXMIN = TMPX1
            BLXMAX = TMPX2
         EndIf
         If(OPTLGX.EQ.'LOGX') Then
            BLXMIN = 10.**(BLXMIN)
            BLXMAX = 10.**(BLXMAX)
         EndIF
         Call HXI(HID,BLXMIN,BXMIN)
         Call HXI(HID,BLXMAX,BXMAX)
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Not 1D-Histogram.'
         Write(*,*)' '
         Return
      EndIf


      CBMIN = ' '
      CBMAX = ' '

      Write(IDTEMP,'(I5)')HID
      Write(CBMIN,*)BXMIN
      Write(CBMAX,*)BXMAX
      Call TGETLEN(CBMIN,TLEN1)
      Call TGETLEN(CBMAX,TLEN2)
      KUCOMLINE = 'HIST/FIT '//IDTEMP//
     &            '('//CBMIN(2:TLEN1)//':'//CBMAX(2:TLEN2)//')'//' G'

      Call KUEXEC(KUCOMLINE)


      Return

      End

c =================================================================
      Subroutine HSTATUS

      Include 'common.f'

      Integer   FKIND,PKIND,TLEN
      Character PRTITLE*80
      Integer   PRNX,PXMINI,PXMAXI,PRNY,PYMINI,PYMAXI,NWT,LOC
      Real      HSTATI
      Integer   NOENT,INCONT
      Real      ENTEFF

      HID = DispID(DSeqID)

      Call HKIND(HID,FKIND,' ')
      
      Call HGIVE(HID,PRTITLE,PRNX,DUMX1,DUMX2,
     &     PRNY,DUMY1,DUMY2,NWT,LOC)
      Call TGETLEN(PRTITLE,TLEN)

      INCONT = HSUM(HID)
      Call HNOENT(HID,NOENT)
      ENTEFF = float(INCONT)/float(NOENT)*100.

      Write(*,*)' '
      Write(*,100)'Histogram ID : ',HID,' TITLE : ',PRTITLE(1:TLEN)
      Write(*,110)'Xbin : ',PRNX,'Xmin : ',DumX1,'Xmax : ',DumX2
      If(FKIND.EQ.1) Then
         Write(*,120)'Mean Value          : ',HSTATI(HID,1,' ',0)
         Write(*,120)'Standard deviation  : ',HSTATI(HID,2,' ',0)
      EndIf
      If(FKIND.EQ.2)
     &     Write(*,110)'Ybin : ',PRNY,'Ymin : ',DumY1,'Ymax : ',DumY2
      If(ENTEFF.GE.0. .AND. ENTEFF.LE.100.)Then
         Write(*,130)NOENT,INCONT,ENTEFF
      Else
         Write(*,140)NOENT,INCONT
      EndIf
      Write(*,*)' '

 100  Format(2X,A15,I5,3X,A9,A)
 110  Format(2X,A7,I6,2X,A7,F10.2,2X,A7,F10.2)
 120  Format(2X,A22,F10.2)
 130  Format(2X,'Entries:',I9,'  Integrated content:',I9,
     &                        '  Ratio:',1F6.2,' %')
 140  Format(2X,'Entries:',I9,'  Integrated content:',I9)

      Return

      End
      
c =================================================================
      Subroutine XSTATUS

      Include 'common.f'
      Real    xvX(2),xvY(2),Tx1,Tx2,Ty1,Ty2
      Integer IvX(2),IvY(2)
      Real    HI,HIJ
      Integer SumCont
      INTEGER ISTAT,NT,FKIND
      Character*4 OPTLGX,OPTLGY

      Character*80 CTITLE
      Integer      CBX,CBY,NWT,LOC
      Real         IPLX(2),IPLY(2)

      Integer NOENT,TLEN
      Real    ENTEFF

      SumCont = 0

      HID = DispID(DSeqID)
      CURRHID = HID

      Call HNOENT(HID,NOENT)

      Call HKIND(CURRHID,FKIND,' ')
      Call HGIVE(CURRHID,CTITLE,CBX,DUMX1,DUMX2,
     &                         CBY,DUMY1,DUMY2,NWT,LOC)
      Call TGETLEN(CTITLE,TLEN)

      OPTLGX = 'LOGX'
      OPTLGY = 'LOGY'

      Call GETHPLOPT(OPTLGX)
      Call GETHPLOPT(OPTLGY)

      Call IRQLC(1,20,ISTAT,NT,Tx1,Ty1)
      If(FKIND.EQ.1) Then
         IPLX(1) = Tx1
         IPLX(2) = Tx1
         IPLY(1) = 0.
         IPLY(2) = HMAX(CURRHID)*10.
         Call IPL(2,IPLX,IPLY)
      ElseIf(FKIND.EQ.2) Then
         IPLX(1) = Tx1
         IPLX(2) = Tx1
         IPLY(1) = DUMY1
         IPLY(2) = DUMY2
         Call IPL(2,IPLX,IPLY)
         IPLX(1) = DUMX1
         IPLX(2) = DUMX2
         IPLY(1) = Ty1
         IPLY(2) = Ty1
         Call IPL(2,IPLX,IPLY)
      EndIf
      Call IRQLC(1,20,ISTAT,NT,Tx2,Ty2)
      If(FKIND.EQ.1) Then
         IPLX(1) = Tx2
         IPLX(2) = Tx2
         IPLY(1) = 0.
         IPLY(2) = HMAX(CURRHID)*10.
         Call IPL(2,IPLX,IPLY)
      EndIf

      If(Tx1.GT.Tx2) Then
         xvX(1) = Tx2
         xvX(2) = Tx1
      Else
         xvX(1) = Tx1
         xvX(2) = Tx2
      EndIf
      If(Ty1.GT.Ty2) Then
         xvY(1) = Ty2
         xvY(2) = Ty1
      Else
         xvY(1) = Ty1
         xvY(2) = Ty2
      EndIf

      If(OPTLGX.EQ.'LOGX') Then
         xvX(1) = 10.**(xvX(1))
         xvX(2) = 10.**(xvX(2))
      EndIf
      If(OPTLGY.EQ.'LOGY') Then
         xvY(1) = 10.**(xvY(1))
         xvY(2) = 10.**(xvY(2))
      EndIf

      If(FKIND.EQ.1) Then

         Call HXI(CURRHID,xvX(1),IvX(1))
         Call HXI(CURRHID,xvX(2),IvX(2))

         Call HCOPYR(HID,99999,' ',IvX(1),IvX(2),0,0,' ')

         Do I = IvX(1) , IvX(2)
            SumCont = SumCont + HI(CURRHID,I)
         EndDo

         ENTEFF = float(SumCont)/float(NOENT)*100.

         Write(*,*)' '
         Write(*,100)'Histogram ID : ',HID,' TITLE : ',CTITLE(1:TLEN)
c         Write(*,'(1X,A5,I5,A20,I10)')
c     &        ' ID: ',CURRHID,'   |      Entries : ',SumCont
         Write(*,'(1X,A16,F8.2,A4,F8.2,A14,I6,A4,I6)')
     &        ' Channel : From ',xvX(1),' to ',xvX(2),
     &        ' | Bin : From ',IvX(1),' to ',IvX(2)
         HID = CURRHID
         Write(*,120)'Mean Value          : ',HSTATI(99999,1,' ',0)
         Write(*,120)'Standard Deviation  : ',HSTATI(99999,2,' ',0)
         If(ENTEFF.GE.0. .AND. ENTEFF.LE.100.)Then
            Write(*,130)NOENT,SumCont,ENTEFF
         Else
            Write(*,140)NOENT,SumCont
         EndIf
         Write(*,*)' '
         Call HDELET(99999)

      ElseIf(FKIND.EQ.2) Then
         Call ISPLCI(0)
         IPLX(1) = Tx1
         IPLX(2) = Tx1
         IPLY(1) = DUMY1
         IPLY(2) = DUMY2
         Call IPL(2,IPLX,IPLY)
         IPLX(1) = DUMX1
         IPLX(2) = DUMX2
         IPLY(1) = Ty1
         IPLY(2) = Ty1
         Call IPL(2,IPLX,IPLY)
         Call ISPLCI(1)
         Call ISFACI(0)
         Call ISFAIS(0)
         Call IGBOX(Tx1,Tx2,Ty1,Ty2)

         Call HXYIJ(CURRHID,xvX(1),xvY(1),IvX(1),IvY(1))
         Call HXYIJ(CURRHID,xvX(2),xvY(2),IvX(2),IvY(2))

         Do I = IvX(1) , IvX(2)
            Do J = IvY(1) , IvY(2)
               SumCont = SumCont + HIJ(CURRHID,I,J)
            EndDo
         EndDo

         ENTEFF = float(SumCont)/float(NOENT)*100.

         Write(*,*)' '
         Write(*,100)'Histogram ID : ',HID,' TITLE : ',CTITLE(1:TLEN)
c         Write(*,'(A5,I5,A20,I10)')
c     &        ' ID: ',CURRHID,'   |      Entries : ',SumCont
         Write(*,'(A18,F8.2,A4,F8.2,A16,I6,A4,I6)')
     &        ' X Channel : From ',xvX(1),' to ',xvX(2),
     &        ' | X Bin : From ',IvX(1),' to ',IvX(2)
         Write(*,'(A18,F8.2,A4,F8.2,A16,I6,A4,I6)')
     &        ' Y Channel : From ',xvY(1),' to ',xvY(2),
     &        ' | Y Bin : From ',IvY(1),' to ',IvY(2)
         If(ENTEFF.GE.0. .AND. ENTEFF.LE.100.)Then
            Write(*,130)NOENT,SumCont,ENTEFF
         Else
            Write(*,140)NOENT,SumCont
         EndIf
         Write(*,*)' '
         HID = CURRHID
      Else

         Write(*,*)' '
         Write(*,*)' ANAPAW-W : No Histogram.'
         Write(*,*)' '

      EndIf
 100  Format(2X,A15,I5,3X,A9,A)
 120  Format(2X,A22,F10.2)
 130  Format(2X,'Entries:',I9,'  Integrated content:',I9,
     &                        '  Ratio:',1F6.2,' %')
 140  Format(2X,'Entries:',I9,'  Integrated content:',I9)

      Return

      End

c =================================================================
      Subroutine HDEL(FHID)

      Include 'common.f'

      Integer   FHID,HNUM,ILOOP/0/
      Character*2 HDELKEY
      Save ILOOP,HDELKEY

      HNUM = 0

      HID = DispID(DSeqID)

      If(ILOOP.EQ.0) Then
         ILOOP = 1
         HDELKEY = 'n'
      EndIf

      If(FHID.EQ.0) Then
         Write(*,*)' '
         Call KUPROS(' Realy Delete!? >',HDELKEY,L)
         If(HDELKEY.EQ.'Y' .or. HDELKEY.EQ.'y') Then
            Call HDELET(HID)
            Call SubDispID(1)
         ElseIf(HDELKEY.EQ.'N' .or. HDELKEY.EQ.'n') Then
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : HDELETE canceled.'
            Write(*,*)' '
         Else
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : Invalid answer.'
            Write(*,*)' '
         EndIf
         
      ElseIf(FHID.NE.0) Then

         Call GetDispID(FHID)
         Call HDELET(FHID)
         Call SubDispID(1)

      EndIf

      Return

      End
      
c =================================================================
      Subroutine MHDEL(HID1,HID2)

      Include 'common.f'

      Integer   HNUM,ILOOP/0/,SDSeqID
      Character HDELKEY*2
      Save ILOOP,HDELKEY

      HNUM = 0

      HID = DispID(DSeqID)
      SDSeqID = DSeqID

      If(ILOOP.EQ.0) Then
         ILOOP = 1
         HDELKEY = 'n'
      EndIf

      If(HID1.EQ.0 .AND. HID2.EQ.0) Then
         Write(*,*)' '
         Call KUPROS(' Realy Delete!? >',HDELKEY,L)
         If(HDELKEY.EQ.'Y' .or. HDELKEY.EQ.'y') Then
            Call HDELET(HID)
            Call SubDispID(1)
            idcount = idcount - 1
         ElseIf(HDELKEY.EQ.'N' .or. HDELKEY.EQ.'n') Then
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : HDELETE canceled.'
            Write(*,*)' '
         Else
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : Invalid answer.'
            Write(*,*)' '
         EndIf
      ElseIf(HID1.NE.0 .AND. HID2.NE.0) Then
         Call GetDispID(HID1)
         SDSeqID = DSeqID
         Do HNUM = HID1, HID2, 1
            If(HEXIST(HNUM))Then
               Call GetDispID(HNUM)
               Call HDELET(HNUM)
               Call SubDispID(1)
               idcount = idcount - 1
            EndIf
         EndDo
      ElseIf(HID1.NE.0 .AND. HID2.EQ.0 .AND. HEXIST(HID1)) Then
         Call GetDispID(HID1)
         SDSeqID = DSeqID
         Call HDELET(HID1)
         Call SubDispID(1)
         idcount = idcount - 1
      EndIf

      If(HEXIST(DispID(SDSeqID))) Then
         DSeqID = SDSeqID
         CURRHID = DispID(DSeqID)
      Else
         DSeqID = SDSeqID-1
         CURRHID = DispID(DSeqID)
      EndIf

      Call ReadDispIDfromPAWC

      Return

      End
c =================================================================
      Subroutine FIGA

      Include 'common.f'

      Integer   FKIND
      Character KUCOMLINE*80,IDTEMP*5

      HID = DispID(DSeqID)

      Call HKIND(HID,FKIND,' ')

      If(FKIND.EQ.1) Then
         Write(IDTEMP,'(I5)')HID
         KUCOMLINE = 'HIST/FIT '//IDTEMP//' G'
         Call KUEXEC(KUCOMLINE)
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Not 1D-Histogram.'
         Write(*,*)' '
      EndIf

      Return

      End

c =================================================================
      Subroutine CUTPRO(HID,COPT)

      Include 'common.f'
      Integer CWKID,KNT,NextHID,TLEN,GIO
      Real    hcutx(20),hcuty(20)
      Real    CPX,CPY,CPCONT
      Real    HXY
      Integer nop,dumkind,ICX,ICY
      Character CPTITLE*80,COPT*4
      Integer   BLNX,BXMIN,BXMAX,BLNY,BYMIN,BYMAX,NWT,LOC

      nop = 1

      If(COPT.EQ.'S')Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-M : Scatter Mode.'
         Call IACWK(4)
         Call IDAWK(1)
         CWKID = 4
         If(HID.EQ.0)Then
            Call KUPROI('HID>',HID)
            CURRHID = HID
         Else
            CURRHID = HID
         EndIf
         Do k = 1, ANUMH2ID
            If(HID.EQ.AH2ID(k))Then
               KNT = k
            EndIf
         EndDo
      ElseIf(COPT.NE.'S')Then
         CWKID = 1
         CURRHID = DispID(DSeqID)
         If(HID.EQ.0)Then
            HID = CURRHID
         Else
            CURRHID = HID
         EndIf
         If(COPT.EQ.'M') COPT=' '
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Wrong option.'
         Write(*,*)' '
         Return
      EndIf

 100  Call HKIND(CURRHID,DUMKIND,' ')
      If(DUMKIND.EQ.-1 .OR. DUMKIND.EQ.0)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Unknown histogram.'
         Write(*,*)' '
         Return
      ElseIf(DUMKIND.EQ.1)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : ',CURRHID,' is 1D-Histogram.'
         Write(*,*)' '
         Call KUPROI(' ID for 2D Histogram>',CURRHID)
         Goto 100
      EndIf

      Call HGIVE(HID,CPTITLE,BLNX,DUMX1,DUMX2,
     &     BLNY,DUMY1,DUMY2,NWT,LOC)
      Call TGETLEN(CPTITLE,TLEN)
      CPTITLE = 'CutProj.'//'('//CPTITLE(1:TLEN)//')'

      Call HIDALL(AIDALL,AMAXHST)
      idcount = AIDALL(AMAXHST)
      idcount = idcount + 1
      NextHID = idcount
      Call AddDispID(NextHID)
      Call HBOOK2(NextHID,CPTITLE,BLNX,DUMX1,DUMX2,
     &                            BLNY,DUMY1,DUMY2,0.)

      Call ISELNT(1)

      If(COPT.NE.'S')Then
         Call HPLOT(HID,COPT,' ',0)
         Call WRTHID(HID)
      EndIf

      Call fcler(hcutx,20)
      Call fcler(hcuty,20)

      Write(*,*)' '

      If(COPT.EQ.'S')Then
         Call UPAWLOC(nop,hcutx(1),hcuty(1),100*KNT,CWKID,'-*')
      Else
         Call UPAWLOC(nop,hcutx(1),hcuty(1),-1,CWKID,'-*')
      EndIf

      If(nop.lt.3)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Need atleast 3 points for a 2D plot'
         Write(*,*)' '
         Return
      EndIf

      Write(*,*)' '
      Write(*,*)' ANAPAW-M : Number of Points = ',nop
      Write(*,*)' '

      If(COPT.EQ.'S')Then
         Call IDAWK(4)
         Call IACWK(1)
      EndIf

      Do ICX = 1,BLNX
         Do ICY = 1,BLNY
            GIO=0
            Call HIJXY(HID,ICX,ICY,CPX,CPY)
            CPX = CPX+abs((DUMX2-DUMX1)/BLNX/2.)
            CPY = CPY+abs((DUMY2-DUMY1)/BLNY/2.)
            Call CHKIO(CPX,CPY,hcutx,hcuty,nop,GIO)
            If(GIO.EQ.1)Then
               CPCONT = HXY(HID,CPX,CPY)
               Call HFILL(NextHID,CPX,CPY,CPCONT)
            EndIf
         EndDo
      EndDo

      Call HPLOT(NextHID,' ',' ',0)
      Write(*,*)'Current Histogram ID : ',NextHID
      Call WRTHID(CURRHID)


 998  Return

      End

c =================================================================
      Subroutine AVY(HID,COPT)

      Include 'common.f'
      Integer CWKID,NextHID,TLEN,GIO
      Real    CPX,CPY,CPCONT
      Real    HXY
      Integer dumkind,ICX,ICY
      Character AVYTITLE*80,COPT*4
      Integer   BLNX,BXMIN,BXMAX,BLNY,BYMIN,BYMAX,NWT,LOC

      CURRHID = DispID(DSeqID)
      If(HID.EQ.0)Then
         HID = CURRHID
      Else
         CURRHID = HID
      EndIf

 100  Call HKIND(CURRHID,DUMKIND,' ')
      If(DUMKIND.EQ.-1 .OR. DUMKIND.EQ.0)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Unknown histogram.'
         Write(*,*)' '
         Return
      ElseIf(DUMKIND.EQ.1)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : ',CURRHID,' is 1D-Histogram.'
         Write(*,*)' '
         Call KUPROI(' ID for 2D Histogram>',CURRHID)
         Goto 100
      EndIf

      Call HGIVE(HID,AVYTITLE,BLNX,DUMX1,DUMX2,
     &     BLNY,DUMY1,DUMY2,NWT,LOC)
      Call TGETLEN(AVYTITLE,TLEN)
      AVYTITLE = 'Avy.'//'('//AVYTITLE(1:TLEN)//')'

      Call HIDALL(AIDALL,AMAXHST)
      idcount = AIDALL(AMAXHST)
      idcount = idcount + 1
      NextHID = idcount
      Call AddDispID(NextHID)
      Call HBPROF(NextHID,AVYTITLE,BLNX,DUMX1,DUMX2,
     &                            DUMY1,DUMY2,COPT)

      Do ICX = 1,BLNX
         Do ICY = 1,BLNY
            Call HIJXY(HID,ICX,ICY,CPX,CPY)
            CPX = CPX+abs((DUMX2-DUMX1)/BLNX/2.)
            CPY = CPY+abs((DUMY2-DUMY1)/BLNY/2.)
            CPCONT = HXY(HID,CPX,CPY)
            Call HFILL(NextHID,CPX,CPY,CPCONT)
         EndDo
      EndDo

      Call HPLOT(NextHID,' ',' ',0)
      Write(*,*)'Current Histogram ID : ',NextHID
      Call WRTHID(CURRHID)


 998  Return

      End

c =================================================================
      Subroutine CUTDRAW(CUTID,CUTNAME,COPT)

      Include 'common.f'
      Integer ISTAT/1/,NT,CWKID,KNT
      Real    xtemp(2),ytemp(2),CNT
      Integer hcutlun,dumkind,CUTID
      Integer FGSEG,FGKIND,FGM,TMPLEN
      Character   CUTNAME*40,COPT*4,TMPTITLE*80
      Character*4 OPTLGX,OPTLGY
      Integer IBNX,IBNY,NWT,LOC,GIO
      Real    RXMIN,RXMAX,RYMIN,RYMAX
      Integer ICX,ICY
      Real    CPX,CPY,CPCONT
      Real    HXY
      Real    rtempx,rtempy,rmeanx,rmeany,rdevx,rdevy
      Character CHCUTGID*5,CHTMPX*10,CHTMPY*10,GIDTEXT*80
      

      save KNT

      OPTLGX = 'LOGX'
      OPTLGY = 'LOGY'

      Call GETHPLOPT(OPTLGX)
      Call GETHPLOPT(OPTLGY)

c      Write(*,*)'1: CUTID   ',CUTID
c      Write(*,*)'1: CUTNAME ',CUTNAME
c      Write(*,*)'1: COPT    ',COPT

      If(COPT.EQ.'S')Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-M : Scatter Mode.'
         Call IACWK(4)
         Call IDAWK(1)
         CWKID = 4
         CURRHID = DispID(DSeqID)
      ElseIf(COPT.NE.'S')Then
         CWKID = 1
         CURRHID = DispID(DSeqID)
         If(COPT.EQ.'M') COPT=' '
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Wrong option.'
         Write(*,*)' '
         Return
      EndIf

      Call IGQWK(CWKID,'NTNB',CNT)
c      write(*,*)'cnt ',cnt
      KNT = int(CNT)
      Call ISELNT(int(CNT))
      If(COPT.EQ.'S')Then
         Call ISELNT(100*ANUMH2ID)
      ElseIf(COPT.NE.'S' .and. KNT.EQ.100*ANUMH2ID)Then
         CWKID = 1
         Call HPLOT(CURRHID,' ',' ',0)
         Call WRTHID(CURRHID)
         Call GetDispID(CURRHID)
         Call IGQWK(CWKID,'NTNB',CNT)
         Call ISELNT(int(CNT))
         KNT = int(CNT)
      EndIf

      Call HKIND(CURRHID,DUMKIND,' ')
      If(DUMKIND.EQ.1)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : ',CURRHID,' is 1D-Histogram.'
         Write(*,*)' '
         Return
      EndIf

      Call HGIVE(CURRHID,TMPTITLE,
     &           IBNX,RXMIN,RXMAX,
     &           IBNY,RYMIN,RYMAX,
     &           NWT,LOC)

c --- check cut ID ---
      If(CUTID.EQ.0)Then
 100     Call KUPROI(' Input ID of 2D-Gate >',CUTID)
         If(CUTID.EQ.0)Goto 100
      EndIf

      If(CUTNAME.NE.' ')Then
         Call KUINQF(CUTNAME,HCUTLUN)
         If(HCUTLUN.EQ.-1)Then
            CUTNAME = ' '
            Goto 101
         EndIf
         Call FINDGATE(CUTID,FGSEG,FGKIND,FGM)
         If(FGKIND.EQ.4)Goto 101
         tdfile(itd) = CUTNAME
         Call TGETLEN(CUTNAME,tdflen(itd))
         Call READCUT(tdfile(itd))
         itd = itd + 1
         gtkind(gseq) = 4
         gseq = gseq + 1
         ckind(cseq) = 4
         cseq = cseq + 1
      EndIf

 101  Call FINDGATE(CUTID,FGSEG,FGKIND,FGM)

      If(FGKIND.NE.4)Then
         Write(*,*)' ANAPAW-W : Not Exist.'
         Write(*,*)' '
         
 102     ANAKEY = 'i'
         Call TGETLEN(ANAKEY,L)
         Call KUPROS(' InputID/InputFile/Quit <i/f/q>',
     &        ANAKEY,L)
         If(ANAKEY.EQ.'i' .OR. ANAKEY.EQ.'I')Then
            Call KUPROI(' Input ID >',CUTID)
            Goto 101
         ElseIf(ANAKEY.EQ.'f' .OR. ANAKEY.EQ.'F')Then
            Call KUPROS('FileName >',CUTNAME,L)
 103        Call KUINQF(CUTNAME,HCUTLUN)

c            write(*,*)'hcutlun',hcutlun

            If(HCUTLUN.EQ.-1)Then
               Write(*,*)' ANAPAW-W : File not exist.'
               Write(*,*)' '
 104           ANAKEY = 'f'
               Call TGETLEN(ANAKEY,L)
               Call KUPROS(' File/Quit <f/q>',
     &              ANAKEY,L)
               If(ANAKEY.EQ.'f' .OR. ANAKEY.EQ.'F')Then
                  Call KUPROS('FileName >',CUTNAME,L)
                  Goto 103
               ElseIf(ANAKEY.EQ.'q' .OR. ANAKEY.EQ.'Q')Then
                  Write(*,*)' '
                  Write(*,*)' ANAPAW-M : Exit CUTDRAW Mode.'
                  Write(*,*)' '
                  goto 998
               Else
                  Goto 104
               EndIf
            EndIf
            tdfile(itd) = CUTNAME
            Call TGETLEN(CUTNAME,tdflen(itd))
            Call READCUT(tdfile(itd))
            itd = itd + 1
            gtkind(gseq) = 4
            gseq = gseq + 1
            ckind(cseq) = 4
            cseq = cseq + 1
            Goto 101
         ElseIf(ANAKEY.EQ.'q' .OR. ANAKEY.EQ.'Q')Then
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : Exit CUTDRAW Mode.'
            Write(*,*)' '
            goto 998
         Else
            Goto 102
         EndIf
      EndIf


      Do i = 1, tdnop(FGM)-1
         xtemp(1) = tdx(i,FGM)
         xtemp(2) = tdx(i+1,FGM)
         ytemp(1) = tdy(i,FGM)
         ytemp(2) = tdy(i+1,FGM)
         If(OPTLGX.EQ.'LOGX')xtemp(1) = LOG10(xtemp(1))
         If(OPTLGX.EQ.'LOGX')xtemp(2) = LOG10(xtemp(2))
         If(OPTLGY.EQ.'LOGY')ytemp(1) = LOG10(ytemp(1))
         If(OPTLGY.EQ.'LOGY')ytemp(2) = LOG10(ytemp(2))
         Call IPL(2,xtemp,ytemp)
      EndDo

      
      xtemp(1) = tdx(tdnop(FGM),FGM)
      xtemp(2) = tdx(1,FGM)
      ytemp(1) = tdy(tdnop(FGM),FGM)
      ytemp(2) = tdy(1,FGM)
      If(OPTLGX.EQ.'LOGX')xtemp(1) = LOG10(xtemp(1))
      If(OPTLGX.EQ.'LOGX')xtemp(2) = LOG10(xtemp(2))
      If(OPTLGY.EQ.'LOGY')ytemp(1) = LOG10(ytemp(1))
      If(OPTLGY.EQ.'LOGY')ytemp(2) = LOG10(ytemp(2))
      Call IPL(2,xtemp,ytemp)

      rtempy = tdy(1,FGM)
      rtempx = tdx(1,FGM)
      Do i = 2, tdnop(FGM)
         If(tdy(i,FGM).ge.rtempy)Then
            rtempx = tdx(i,FGM)
            rtempy = tdy(i,FGM)
         EndIf
      EndDo
      Write(CHCUTGID,*)CUTID
      Write(CHTMPX,*)rtempx
      Write(CHTMPY,*)rtempy
      If(COPT.EQ.'S')Then
         GIDTEXT = 'TEXT '//CHTMPX//' '//CHTMPY//' '//CHCUTGID//' 0.02'
         Call KUEXEC(GIDTEXT)
      Else
         GIDTEXT = 'TEXT '//CHTMPX//' '//CHTMPY//' '//CHCUTGID//' 0.3'
         Call KUEXEC(GIDTEXT)
      EndIf
      Call FINDHID(CURRHID,HCKIND,HCJ)

      Call HBOOK2(99999,'temp',IBNX,RXMIN,RXMAX,
     &                         IBNY,RYMIN,RYMAX,0.)

      CPCONT = 0.

      Do ICX = 1, IBNX
         Do ICY = 1, IBNY
            GIO = 0
            Call HIJXY(CURRHID,ICX,ICY,CPX,CPY)
            CPX = CPX + abs((RXMAX-RXMIN)/IBNX/2.)
            CPY = CPY + abs((RYMAX-RYMIN)/IBNY/2.)
            Call CHKIO(CPX,CPY,tdx(1,FGM),tdy(1,FGM),
     &                 tdnop(FGM),GIO)
            If(GIO.EQ.1)Then
               CPCONT = CPCONT + HXY(CURRHID,CPX,CPY)
               Call HFILL(99999,CPX,CPY,CPCONT)
            EndIf
         EndDo
      EndDo

      Call KUEXEC('PROX 99999')
      Call KUEXEC('PROY 99999')
      Call KUEXEC('HIST/PROJECT 99999')
      Call KUEXEC('HI/COPY 99999.PROX 99997')
      Call KUEXEC('HI/COPY 99999.PROY 99998')
      rmeanx = HSTATI(99997,1,' ',0)
      rdevx  = HSTATI(99997,2,' ',0)
      rmeany = HSTATI(99998,1,' ',0)
      rdevy  = HSTATI(99998,2,' ',0)
      Call HDELET(99997)
      Call HDELET(99998)
      Call HDELET(99999)

      Call TGETLEN(TMPTITLE,TMPLEN)

      Write(*,*)' '
      Write(*,200)'Histogram ID : ',CURRHID,' TITLE : ',
     &            TMPTITLE(1:TMPLEN)
      Write(*,210)'Xbin : ',IBNX,'Xmin : ',RXMIN,'Xmax : ',RXMAX
      Write(*,210)'Ybin : ',IBNY,'Ymin : ',RYMIN,'Ymax : ',RYMAX
      Write(*,*)' '
      Write(*,1008)'GID : ',tdgateid(FGM),
     &     '     KIND : XYGate   '
      Write(*,1009)'VAL_X : ',tdsegidx(FGM),
     &     tdvidx1(FGM),tdvidx2(FGM),
     &     tdvalx(FGM),'     VAL_Y : ',
     &     tdsegidy(FGM),
     &     tdvidy1(FGM),tdvidy2(FGM),
     &     tdvaly(FGM),'  '
      Write(*,1010)'Number of Points   : ',tdnop(FGM),'  '
      Write(*,1011)'Integrated content : ',INT(CPCONT),'  '
      Write(*,1012)'ACCEPTED ENTRIES   : ',acctdgate(FGM)
      Write(*,*)' '
      Write(*,1013)'Mean ( ',rmeanx,',',rmeany,' )'
      Write(*,1013)'STD  ( ',rdevx,',',rdevy,' )'
      Write(*,*)' '

      If(COPT.EQ.'S')Then
         Call IDAWK(4)
         Call IACWK(1)
      EndIf

 200  Format(2X,A15,I5,3X,A9,A)
 210  Format(2X,A7,I6,2X,A7,F10.2,2X,A7,F10.2)

 1008 Format(A10,I4,A22)
 1009 Format(A15,I3,I4,I4,I4,A14,I3,I4,I4,I4,A3)
 1010 Format(A28,I5,A3)
 1011 Format(A28,I8,A3)
 1012 Format(A28,I8)
 1013 Format(2X,A7,F10.4,A3,F10.4,A2)


 998  Return

      End


c =================================================================
      Subroutine CHBIN(BF,NBINS)

      Include 'common.f'

      Integer   NextHID,FKIND,TLEN
      Character BLTITLE*80
      Integer   BLNX,BXMIN,BXMAX,BLNY,BYMIN,BYMAX,NWT,LOC
      Integer   BF

      Integer   NBINS
      Real      CX(NBINS),CY(NBINS),EX(NBINS),EY(NBINS)
      
      HID = DispID(DSeqID)
c      write(*,*)'chbin : ',hid
      Call HKIND(HID,FKIND,' ')
      Call HGIVE(HID,BLTITLE,BLNX,DUMX1,DUMX2,
     &     BLNY,DUMY1,DUMY2,NWT,LOC)
      Call HXI(HID,DUMX1,BXMIN)
      Call HXI(HID,DUMX2,BXMAX)

c -- 2D Histogram --
      If(FKIND.EQ.2 .AND. FKIND.NE.1) Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-W : Not 1D-Histogram.'
         Write(*,*)' '
         Return
      ElseIf(FKIND.NE.1)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-W : No Histograms.'
         Write(*,*)' '
         Return
      EndIf
         
      Call TGETLEN(BLTITLE,TLEN)
      BLTITLE = 'Chbin.'//'('//BLTITLE(1:TLEN)//')'
         
      If(HEXIST(HID))Then
         Call HIDALL(AIDALL,AMAXHST)
         idcount = AIDALL(AMAXHST)
         idcount = idcount + 1
         NextHID = idcount
         Call AddDispID(NextHID)
c         Call HBOOK1(NextHID,BLTITLE,NBINS,BXMIN,BXMAX,0.)

         Call HBOOK1(NextHID,BLTITLE,NBINS,DUMX1,DUMX2,0.)
c         Write(*,*)HID,NBINS,DUMX1,BXMIN,DUMX2,BXMAX
c         Call HREBIN(HID,CX,CY,EX,EY,NBINS,DUMX1,DUMX2)
         Call HREBIN(HID,CX,CY,EX,EY,NBINS,BXMIN,BXMAX)


         Do I = 1,NBINS
            CX(I) = (DUMX2-DUMX1)/real(NBINS)*I + DUMX1 
     &            - (DUMX2-DUMX1)/real(NBINS)/2.
            CY(I) = CY(I) * REAL(BF)
            Call HFILL(NextHID,CX(I),0.,CY(I))
c            write(*,*)I,CX(I),CY(I)
         EndDo

c         Call HCOPYR(HID,NextHID,BLTITLE,
c     &        BXMIN,BXMAX-1,0,0,' ')
c         Call HMINIM(NextHID,BYMIN)
c         Call HMAXIM(NextHID,BYMAX)

         Call HPLOT(NextHID,' ',' ',0)
         Write(*,*)'Current Histogram ID : ',NextHID
         Call WRTHID(CURRHID)
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-W : No Histograms.'
         Write(*,*)' '
      EndIf
      
      Return

      End
      
c =================================================================
      Subroutine GCUTPRO(CUTID,CUTNAME,COPT)

      Include 'common.f'
      Integer ISTAT/1/,NT,CWKID,KNT
      Real    xtemp(2),ytemp(2),CNT
      Integer hcutlun,dumkind,CUTID
      Integer FGSEG,FGKIND,FGM,TMPLEN
      Character   CUTNAME*40,COPT*4,TMPTITLE*80
      Character*4 OPTLGX,OPTLGY
      Integer IBNX,IBNY,NWT,LOC,GIO
      Real    RXMIN,RXMAX,RYMIN,RYMAX
      Integer ICX,ICY
      Real    CPX,CPY,CPCONT
      Real    HXY
      Real    rtempx,rtempy,rmeanx,rmeany,rdevx,rdevy
      Character CHCUTGID*5,CHTMPX*10,CHTMPY*10,GIDTEXT*80
      Character CPTITLE*80
      Integer   BLNX,BXMIN,BXMAX,BLNY,BYMIN,BYMAX
      Integer   NextHID,TLEN

      save KNT

      OPTLGX = 'LOGX'
      OPTLGY = 'LOGY'

      Call GETHPLOPT(OPTLGX)
      Call GETHPLOPT(OPTLGY)

c      Write(*,*)'1: CUTID   ',CUTID
c      Write(*,*)'1: CUTNAME ',CUTNAME
c      Write(*,*)'1: COPT    ',COPT

      If(COPT.EQ.'S')Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-M : Scatter Mode.'
         Call IACWK(4)
         Call IDAWK(1)
         CWKID = 4
         CURRHID = DispID(DSeqID)
      ElseIf(COPT.NE.'S')Then
         CWKID = 1
         CURRHID = DispID(DSeqID)
         If(COPT.EQ.'M') COPT=' '
      Else
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : Wrong option.'
         Write(*,*)' '
         Return
      EndIf

      Call IGQWK(CWKID,'NTNB',CNT)
c      write(*,*)'cnt ',cnt
      KNT = int(CNT)
      Call ISELNT(int(CNT))
      If(COPT.EQ.'S')Then
         Call ISELNT(100*ANUMH2ID)
      ElseIf(COPT.NE.'S' .and. KNT.EQ.100*ANUMH2ID)Then
         CWKID = 1
         Call HPLOT(CURRHID,' ',' ',0)
         Call WRTHID(CURRHID)
         Call GetDispID(CURRHID)
         Call IGQWK(CWKID,'NTNB',CNT)
         Call ISELNT(int(CNT))
         KNT = int(CNT)
      EndIf

      Call HKIND(CURRHID,DUMKIND,' ')
      If(DUMKIND.EQ.1)Then
         Write(*,*)' '
         Write(*,*)' ANAPAW-E : ',CURRHID,' is 1D-Histogram.'
         Write(*,*)' '
         Return
      EndIf

      Call HGIVE(CURRHID,TMPTITLE,
     &           IBNX,RXMIN,RXMAX,
     &           IBNY,RYMIN,RYMAX,
     &           NWT,LOC)

c --- check cut ID ---
      If(CUTID.EQ.0)Then
 100     Call KUPROI(' Input ID of 2D-Gate >',CUTID)
         If(CUTID.EQ.0)Goto 100
      EndIf

      If(CUTNAME.NE.' ')Then
         Call KUINQF(CUTNAME,HCUTLUN)
         If(HCUTLUN.EQ.-1)Then
            CUTNAME = ' '
            Goto 101
         EndIf
         Call FINDGATE(CUTID,FGSEG,FGKIND,FGM)
         If(FGKIND.EQ.4)Goto 101
         tdfile(itd) = CUTNAME
         Call TGETLEN(CUTNAME,tdflen(itd))
         Call READCUT(tdfile(itd))
         itd = itd + 1
         gtkind(gseq) = 4
         gseq = gseq + 1
         ckind(cseq) = 4
         cseq = cseq + 1
      EndIf

 101  Call FINDGATE(CUTID,FGSEG,FGKIND,FGM)

      If(FGKIND.NE.4)Then
         Write(*,*)' ANAPAW-W : Not Exist.'
         Write(*,*)' '
         
 102     ANAKEY = 'i'
         Call TGETLEN(ANAKEY,L)
         Call KUPROS(' InputID/InputFile/Quit <i/f/q>',
     &        ANAKEY,L)
         If(ANAKEY.EQ.'i' .OR. ANAKEY.EQ.'I')Then
            Call KUPROI(' Input ID >',CUTID)
            Goto 101
         ElseIf(ANAKEY.EQ.'f' .OR. ANAKEY.EQ.'F')Then
            Call KUPROS('FileName >',CUTNAME,L)
 103        Call KUINQF(CUTNAME,HCUTLUN)

c            write(*,*)'hcutlun',hcutlun

            If(HCUTLUN.EQ.-1)Then
               Write(*,*)' ANAPAW-W : File not exist.'
               Write(*,*)' '
 104           ANAKEY = 'f'
               Call TGETLEN(ANAKEY,L)
               Call KUPROS(' File/Quit <f/q>',
     &              ANAKEY,L)
               If(ANAKEY.EQ.'f' .OR. ANAKEY.EQ.'F')Then
                  Call KUPROS('FileName >',CUTNAME,L)
                  Goto 103
               ElseIf(ANAKEY.EQ.'q' .OR. ANAKEY.EQ.'Q')Then
                  Write(*,*)' '
                  Write(*,*)' ANAPAW-M : Exit CUTDRAW Mode.'
                  Write(*,*)' '
                  goto 998
               Else
                  Goto 104
               EndIf
            EndIf
            tdfile(itd) = CUTNAME
            Call TGETLEN(CUTNAME,tdflen(itd))
            Call READCUT(tdfile(itd))
            itd = itd + 1
            gtkind(gseq) = 4
            gseq = gseq + 1
            ckind(cseq) = 4
            cseq = cseq + 1
            Goto 101
         ElseIf(ANAKEY.EQ.'q' .OR. ANAKEY.EQ.'Q')Then
            Write(*,*)' '
            Write(*,*)' ANAPAW-M : Exit CUTDRAW Mode.'
            Write(*,*)' '
            goto 998
         Else
            Goto 102
         EndIf
      EndIf

      Call HGIVE(CURRHID,CPTITLE,BLNX,DUMX1,DUMX2,
     &     BLNY,DUMY1,DUMY2,NWT,LOC)
      Call TGETLEN(CPTITLE,TLEN)
      CPTITLE = 'GcutProj.'//'('//CPTITLE(1:TLEN)//')'

      HID = CURRHID

      Call HIDALL(AIDALL,AMAXHST)
      idcount = AIDALL(AMAXHST)
      idcount = idcount + 1
      NextHID = idcount
      Call AddDispID(NextHID)
      Call HBOOK2(NextHID,CPTITLE,BLNX,DUMX1,DUMX2,
     &                            BLNY,DUMY1,DUMY2,0.)

      Do ICX = 1,BLNX
         Do ICY = 1,BLNY
            GIO=0
            Call HIJXY(CURRHID,ICX,ICY,CPX,CPY)
            CPX = CPX+abs((DUMX2-DUMX1)/BLNX/2.)
            CPY = CPY+abs((DUMY2-DUMY1)/BLNY/2.)
            Call CHKIO(CPX,CPY,tdx(1,FGM),tdy(1,FGM),tdnop(FGM),GIO)
 
            If(GIO.EQ.1)Then
               CPCONT = HXY(HID,CPX,CPY)
               Call HFILL(NextHID,CPX,CPY,CPCONT)
            EndIf
         EndDo
      EndDo

      Call HPLOT(NextHID,COPT,' ',0)
      Write(*,*)'Current Histogram ID : ',NextHID
      Call WRTHID(CURRHID)

 998  Return

      End


