      SUBROUTINE ANAMNU
      CHARACTER*1  BS1
      PARAMETER   (BS1='\\')
      PARAMETER   (MGUIDL=199)
      CHARACTER*160 GuID(MGUIDL)

      COMMON/KCGuID/GuID

      EXTERNAL ANAACT

C /ANALYS - MENU -

      CALL KUCMD(' ','ANALYS','C')
      GuID(1)=' On(Off)-Line Analysis Software on PAW. '
      GuID(2)=' '
      GuID(3)=' This Command List provides you ANALYS-like procedure.'
      GuID(4)=' '
      GuID(5)='                   (c) S.Takeuchi, Rikkyo Univ., 2000.'
      CALL KUGuID('ANALYS',GuID,5,'S')
 
      CALL KUCMD('ANALYS',' ','SW')

C /ANALYS/DEFINITION - MENU -
 
      CALL KUCMD(' ','DEFINITION','C')
      GuID(1)=' Define and Book Histograms using ANALYS-CODE.'
      GuID(2)=' '
      CALL KUGuID('DEFINITION',GuID,2,'S')

      CALL KUCMD('DEFINITION',' ','SW')

C /ANALYS/DEFINITION/BOOK - COMMAND -

      CALL KUCMD(' ','BOOK','C')
      CALL KUPAR('BOOK','FNAME','ANAFILE name','CO','S')
      CALL KUPVAL('BOOK','FNAME',0,0.,' ','D')
      GuID(1)='  Open analysis input file and book histograms.'
      GuID(2)=' '
      GuID(3)='  ANAPAW> analays/histo/book hogehoge.ana '
      GuID(4)=' '
      GuID(5)='  If FNAME is null, EDIT-MODE for .ana-file is opend.'
      CALL KUGuID('BOOK',GuID,5,'S')
      CALL KUACT('BOOK',ANAACT)

C /ANALYS/DEFINITION/CLEAR - COMMAND -
      
      CALL KUCMD(' ','CLEAR','C')
      CALL KUPAR('CLEAR','CHOPT','Options ','OO','S')
      CALL KUPVAL('CLEAR','CHOPT',0,0.,' ','D')
      CALL KUPVAL('CLEAR','CHOPT',0,0.,' ,F','V')
      CALL KUPVAL('CLEAR','CHOPT',0,0.,'   Default','- ')
      CALL KUPVAL('CLEAR','CHOPT',0,0.,'   Force','-F')
      GuID(1)='  Clear all histogram definitions, histograms and '// 
     &'event summary.'
      CALL KUGuID('CLEAR',GuID,1,'S')
      CALL KUACT('CLEAR',ANAACT)

C /ANALYS/DEFINITION/ANAADD - COMMAND -

      CALL KUCMD(' ','ANAADD','C')
      CALL KUPAR('ANAADD','ANAADDNAME',
     &           'File to save ANALYS Code','CO','S')
      CALL KUPVAL('ANAADD','ANAADDNAME',0,0.,'fort.ana','D')
      GuID(1)='  Add analys parameter.'
      GuID(2)=' '
      CALL KUGuID('ANAADD',GuID,2,'S')
      CALL KUACT('ANAADD',ANAACT)

C /ANALYS/DEFINITION/AWRITE - COMMAND -

      CALL KUCMD(' ','AWRITE','C')
      CALL KUPAR('AWRITE','ANAWNAME',
     &           'File to save ANALYS Code','CO','S')
      CALL KUPVAL('AWRITE','ANAWNAME',0,0.,'awrite.ana','D')
      GuID(1)='  Write analys parameters to a given filename.'
      GuID(2)=' '
      CALL KUGuID('AWRITE',GuID,2,'S')
      CALL KUACT('AWRITE',ANAACT)

C /ANALYS/DEFINITION/CHGATE - COMMAND -

      CALL KUCMD(' ','CHGATE','C')
      CALL KUPAR('CHGATE','GID',
     &           'Gate ID to change a definition.','IO','S')
      CALL KUPVAL('CHGATE','GID',0,0.,' ','D')
      GuID(1)='  Change a definition of given Gate ID. You can '//
     &'change a definition of [GATE], [AND] and [OR].'
      GuID(2)=' '
      CALL KUGuID('CHGATE',GuID,2,'S')
      CALL KUACT('CHGATE',ANAACT)

C /ANALYS/DEFINITION/CHHST - COMMAND -

      CALL KUCMD(' ','CHHST','C')
      CALL KUPAR('CHHST','HID',
     &           '1D-Histogram ID to change a definition.','IO','S')
      CALL KUPVAL('CHHST','HID',0,0.,' ','D')
      CALL KUPAR('CHHST','CHOPT','Options ','OO','S')
      CALL KUPVAL('CHHST','CHOPT',0,0.,' ','D')
      CALL KUPVAL('CHHST','CHOPT',0,0.,' ,X,Y,T','V')
      CALL KUPVAL('CHHST','CHOPT',0,0.,
     &     '   Change a definition by Command Line.','- ')
      CALL KUPVAL('CHHST','CHOPT',0,0.,
     &     '   Change a X-Range on Xwindow by mouse.','-X')
      CALL KUPVAL('CHHST','CHOPT',0,0.,
     &     '   Change a Y-Range on Xwindow by mouse (only 2D).','-Y')
      CALL KUPVAL('CHHST','CHOPT',0,0.,
     &     '   Change a XY-Range on Xwindow by mouse (only 2D).','-T')
      GuID(1)='  Change a definition of a given Histogram ID.'
      GuID(2)=' '
      CALL KUGuID('CHHST',GuID,2,'S')
      CALL KUACT('CHHST',ANAACT)

C /ANALYS/DEFINITION/HST1 - COMMAND -
      
      CALL KUCMD(' ','HST1','C')
      CALL KUPAR('HST1','NX','Number of divisions along X ','IO','S')
      CALL KUPVAL('HST1','NX',2,0.,' ','D')
      CALL KUPAR('HST1','NY','Number of divisions along Y ','IO','S')
      CALL KUPVAL('HST1','NY',2,0.,' ','D')
      GuID(1)='  Define ZONE ,IDs of Histograms to see .'
      GuID(2)=' '
      CALL KUGuID('HST1',GuID,2,'S')
      CALL KUACT('HST1',ANAACT)

C /ANALYS/DEFINITION/HST2 - COMMAND -
      
      CALL KUCMD(' ','HST2','C')
      CALL KUPAR('HST2','N2X','Number of divisions along X ','IO','S')
      CALL KUPVAL('HST2','N2X',1,0.,' ','D')
      CALL KUPAR('HST2','N2Y','Number of divisions along Y ','IO','S')
      CALL KUPVAL('HST2','N2Y',1,0.,' ','D')
      GuID(1)='  Define ZONE ,IDs of 2D-Histograms to see .'
      GuID(2)=' '
      CALL KUGuID('HST2',GuID,2,'S')
      CALL KUACT('HST2',ANAACT)

C /ANALYS/DEFINITION/LISTPROF - COMMAND -
      
      CALL KUCMD(' ','LISTPROF','C')
      GuID(1)='  Print definitions of Profile-Histograms'
      GuID(2)='  '
      GuID(3)=' HID =  0, All lists are displayed.'
      CALL KUPAR('LISTPROF','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('LISTPROF','HID',0,0.,' ','D')
      CALL KUGuID('LISTPROF',GuID,3,'S')
      CALL KUACT('LISTPROF',ANAACT)

C /ANALYS/DEFINITION/LIST1D - COMMAND -
      
      CALL KUCMD(' ','LIST1D','C')
      GuID(1)='  Print definitions of 1D-Histograms'
      GuID(2)='  '
      GuID(3)=' HID =  0, All lists are displayed.'
      GuID(4)=' HID = -1, Definitions of histograms defined by HST1 are'
      GuID(5)='           displayed.'
      CALL KUPAR('LIST1D','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('LIST1D','HID',0,0.,' ','D')
      CALL KUGuID('LIST1D',GuID,5,'S')
      CALL KUACT('LIST1D',ANAACT)

C /ANALYS/DEFINITION/LIST2D - COMMAND -
      
      CALL KUCMD(' ','LIST2D','C')
      GuID(1)='  Print definitions of 2D-Histograms'
      GuID(2)='  '
      GuID(3)=' HID =  0, All lists are displayed.'
      GuID(4)=' HID = -1, Definitions of histograms defined by HST2 are'
      GuID(5)='           displayed.'
      CALL KUPAR('LIST2D','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('LIST2D','HID',0,0.,' ','D')
      CALL KUGuID('LIST2D',GuID,5,'S')
      CALL KUACT('LIST2D',ANAACT)

C /ANALYS/DEFINITION/LISTGATE - COMMAND -
      
      CALL KUCMD(' ','LISTGATE','C')
      CALL KUPAR('LISTGATE','GKIND','Kind of Gates ','OO','S')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,' ','D')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,' ,G,A,O,X','V')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,
     &     '   All Gates are displayed','- ')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,
     &     '   Gates defined by [GATE] are displayed.','-G')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,
     &     '   Gates defined by [AND] are displayed.','-A')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,
     &     '   Gates defined by [OR] are displayed.','-O')
      CALL KUPVAL('LISTGATE','GKIND',0,0.,
     &     '   Gates defined by [XYGATE] are displayed.','-X')
      GuID(1)='  Print definitions of Gates defined by ANA-CODE. '
      GuID(2)='  '
      CALL KUGuID('LISTGATE',GuID,2,'S')
      CALL KUACT('LISTGATE',ANAACT)

C /ANALYS/DEFINITION/AVIEW - COMMAND -
      
      CALL KUCMD(' ','AVIEW','C')
      CALL KUPAR('AVIEW','VIO','Open/Close','CO','S')
      CALL KUPVAL('AVIEW','VIO',0,0.,'O','D')
      CALL KUPVAL('AVIEW','VIO',0,0.,'O,C','V')
      CALL KUPVAL('AVIEW','VIO',0,0.,'   Open ANA View.','-O') 
      CALL KUPVAL('AVIEW','VIO',0,0.,'   Close ANA View.','-C') 
      GuID(1)='  Open Viewer for ANALYS-CODE.'
      GuID(2)=' '
      CALL KUGuID('AVIEW',GuID,2,'S')
      CALL KUACT('AVIEW',ANAACT)

C /ANALYS/DEFINITION/HCUT - COMMAND -
      
      CALL KUCMD(' ','HCUT','C')
      CALL KUPAR('HCUT','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('HCUT','HID',0,0.,' ','D')
      CALL KUPAR('HCUT','HCUTNAME',
     &           'File to save 2D-Gate Data','CO','S')
      CALL KUPVAL('HCUT','HCUTNAME',0,0.,'anapaw.cut','D')
      CALL KUPAR('HCUT','COPT','Window Option','CO','S')
      CALL KUPVAL('HCUT','COPT',0,0.,'M','D')
      CALL KUPVAL('HCUT','COPT',0,0.,'M,S,OPT','V')
      CALL KUPVAL('HCUT','COPT',0,0.,'   Main Window','-M')
      CALL KUPVAL('HCUT','COPT',0,0.,'   Scatter Window','-S')
      CALL KUPVAL('HCUT','COPT',0,0.,'   HPLOT Option','-OPT')
      GuID(1)='  Create 2d-Gate Date File.'
      GuID(2)=' It needs to input GateID before make gates. '
      GuID(3)=' If HID = 0, Current Histogram is displayed. '
      GuID(4)=' '
      CALL KUGuID('HCUT',GuID,4,'S')
      CALL KUACT('HCUT',ANAACT)

C /ANALYS/DEFINITION/LISTEFF - COMMAND -
      
      CALL KUCMD(' ','LISTEFF','C')
      CALL KUPAR('LISTEFF','GID','Gate ID ','IO','S')
      CALL KUPVAL('LISTEFF','GID',0,0.,' ','D')
      GuID(1)='  Print efficiency list defined by LEFF in anafile. '
      GuID(2)=' '
      GuID(3)=' GID = 0 : Denominator is a number of valid events.'
      GuID(4)=' You can choose other gate ID as denominator instead '
      GuID(5)=' of valid events.'
      GuID(6)=' '
      CALL KUGuID('LISTEFF',GuID,6,'S')
      CALL KUACT('LISTEFF',ANAACT)

      CALL KUCMD('..',' ','SW')


C /ANALYS/SWITCH - MENU -
 
      CALL KUCMD(' ','SWITCH','C')
      GuID(1)=' Manipulation of RIDF analysis.'
      GuID(2)=' '
      CALL KUGuID('SWITCH',GuID,2,'S')

      CALL KUCMD('SWITCH',' ','SW')

C /ANALYS/SWITCH/DEVICE - COMMAND -
      
      CALL KUCMD(' ','DEVICE','C')
      GuID(1)='  Define devices used in analysis.'
      GuID(2)='  DEV is device number.'
      GuID(3)='  FLAG is 0, 1, 2, or -1. Default is 1'
      GuID(4)='  FLAG = 0  : analysis w/o Device indicated DEV.'
      GuID(5)='  FLAG = 1  : analysis w/ Device indicated DEV.'
      GuID(6)='  FLAG = 2  : analysis w/ all Device.'
      GuID(7)='  FLAG = -1 : analysis w/ only Device indicated DEV.'
      CALL KUPAR('DEVICE','DEV','Device number ','IO','S')
      CALL KUPVAL('DEVICE','DEV',0,0.,' ','D')
      CALL KUPAR('DEVICE','FLAG','Flag ','IO','S')
      CALL KUPVAL('DEVICE','FLAG',1,0.,' ','D')
      CALL KUGuID('DEVICE',GuID,7,'S')
      CALL KUACT('DEVICE',ANAACT)


C /ANALYS/SWITCH/SHMID - COMMAND -
      
      CALL KUCMD(' ','SHMID','C')
      GuID(1)='  Define shared memory used in the analysis'
      GuID(2)='  '
      CALL KUPAR('SHMID','SHM','Shared memory id ','IO','S')
      CALL KUPVAL('SHMID','SHM',0,0.,' ','D')
      CALL KUGuID('SHMID',GuID,2,'S')
      CALL KUACT('SHMID',ANAACT)


C /ANALYS/SWITCH/IHIT - COMMAND -
      
      CALL KUCMD(' ','IHIT','C')
      CALL KUPAR('IHIT','FLAG','FLAG ','IO','S')
      CALL KUPVAL('IHIT','FLAG',1,0.,' ','D')
      GuID(1)='  Define flag for ihit analysis'
      GuID(2)='  '
      CALL KUGuID('IHIT',GuID,2,'S')
      CALL KUACT('IHIT',ANAACT)

      CALL KUCMD('..',' ','SW')

C /ANALYS/HISTOGRAM - MENU -
 
      CALL KUCMD(' ','HISTOGRAM','C')
      GuID(1)=' Manipulation of Histograms.'
      GuID(2)=' '
      CALL KUGuID('HISTOGRAM',GuID,2,'S')

      CALL KUCMD('HISTOGRAM',' ','SW')

C /ANALYS/HISTOGRAM/HSTORE - COMMAND -
      
      CALL KUCMD(' ','HSTORE','C')
      CALL KUPAR('HSTORE','HBKFILENAME',
     &           'Filename to save the Histograms ','CO','S')
      CALL KUPVAL('HSTORE','HBKFILENAME',0,0.,'ANAPAW.HBK','D')
      GuID(1)='  Store the Histograms in //PAWC to HBKFILENAME.'
      GuID(2)=' '
      CALL KUGuID('HSTORE',GuID,2,'S')
      CALL KUACT('HSTORE',ANAACT)

C /ANALYS/HISTOGRAM/FETCH - COMMAND -
      
      CALL KUCMD(' ','FETCH','C')
      CALL KUPAR('FETCH','HBKFILENAME',
     &           'Filename to load the Histograms ','CO','S')
      CALL KUPVAL('FETCH','HBKFILENAME',0,0.,'ANAPAW.HBK','D')
      CALL KUPAR('FETCH','OFFSET','Offset for Histogram ID ','IO','S')
      CALL KUPVAL('FETCH','OFFSET',0,0.,' ','D')
      GuID(1)='  Fetch the Histograms in HBKFILENAME to //PAWC.'
      GuID(2)=' '
      CALL KUGuID('FETCH',GuID,2,'S')
      CALL KUACT('FETCH',ANAACT)


C /ANALYS/HISTOGRAM/HT - COMMAND -
      
      CALL KUCMD(' ','HT','C')
      GuID(1)='  Plot a Histogram. '
      GuID(2)='  This Command saves Current Histogram Number.'
      GuID(3)=' '
      CALL KUPAR('HT','HID','Histogram ID ','IO','S')
      CALL KUPVAL('HT','HID',0,0.,' ','D')
      CALL KUPAR('HT','CHOPT','Options ','OO','S')
      CALL KUPVAL('HT','CHOPT',0,0.,' ','D')
      CALL KUPVAL('HT','CHOPT',0,0.,' ,C,S,+,-,+-,B,L,P,*','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'E,E0,E1,E2,E3,E4,A,BOX,COL,Z','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'SURF,SURF1,SURF2,SURF3,SURF4','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'LEGO,LEGO1,LEGO2,BB,FB','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'CONT,TEXT,CHAR','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'HIST,FUNC,CYL,POL,SPH,PSD','V')
      CALL KUPVAL('HT','CHOPT',0,0.,'Draw the histogram.','- ')
      CALL KUPVAL('HT','CHOPT',0,0.,'Draw a smooth curve.','-C')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Superimpose plot on top of existing picture.','-S')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Add contents of ID to last plotted histogram.','-+')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Substract contents of ID to last plotted histogram.','--')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw the delta with the last plotted histogram.','-+-')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Select Bar chart format.','-B')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Connect channels contents by a line.','-L')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw the current polymarker at each channel or cell.','-P')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw a * at each channel.','-*')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw error bars and current marker.','-E')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw error bars without symbols clipping.','-E0')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw small lines at the end of the error bars.','-E1')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw error rectangles.','-E2')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw a filled area through the end points_
     & of the vertical error bars.','-E3')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw a smoothed filled area through the end points_
     & of the vertical error bars.','-E4')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Axis labels and tick marks are not drawn.','-A')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw 2-Dim with proportional boxes.','-BOX')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw 2-Dim with a color table.','-COL')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Used with COL or SURF, it draws the color map.','-Z')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw as a surface plot (angles are set via the command angle).'
     & ,'-SURF')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw as a surface with color levels','-SURF1')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Same as SURF1 but without cell lines.','-SURF2')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Same as SURF but with the contour plot (in color) on top.'
     &,'-SURF3')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw as a surface with Gouraud shading.','-SURF4')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw as a lego plot (angles are set via the command angle).'
     & ,'-LEGO')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw lego plot with light simulation.','-LEGO1')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw lego plot with color levels.','-LEGO2')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Suppress the Back Box on 3D plots.','-BB')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Suppress the Front Box on 3D plots.','-FB')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw 2-Dim as a contour plot (15 levels).','-CONT')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw 2-Dim as a table.','-TEXT')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw 2-Dim with characters (a la HBOOK).','-CHAR')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw only histogram (no errors or associated function).'
     & ,'-HIST')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Draw only the associated function (not the histogram).'
     & ,'-FUNC')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Cylindrical coordinates for 3D plots.','-CYL')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Polar coordinates for 3D plots.','-POL')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Spherical coordinates for 3D plots.','-SPH')
      CALL KUPVAL('HT','CHOPT',0,0.,
     & 'Pseudo-rapidity/phi coordinates for 3D plots.','-PSD')
      CALL KUGuID('HT',GuID,3,'S')
      CALL KUACT('HT',ANAACT)

C /ANALYS/HISTOGRAM/HNT - COMMAND -
      
      CALL KUCMD(' ','HNT','C')
      GuID(1)='  Plot a Next Histogram. '
      GuID(2)='  CHOPT is same definition of HT command.'
      GuID(3)=' '
      CALL KUPAR('HNT','CHOPT','Options ','OO','S')
      CALL KUPVAL('HNT','CHOPT',0,0.,' ','D')
      CALL KUGuID('HNT',GuID,3,'S')
      CALL KUACT('HNT',ANAACT)

C /ANALYS/HISTOGRAM/HBT - COMMAND -
      
      CALL KUCMD(' ','HBT','C')
      GuID(1)='  Plot a Previous Histogram. '
      GuID(2)='  CHOPT is same definition of HT command.'
      GuID(3)='  '
      CALL KUPAR('HBT','CHOPT','Options ','OO','S')
      CALL KUPVAL('HBT','CHOPT',0,0.,' ','D')
      CALL KUGuID('HBT',GuID,3,'S')
      CALL KUACT('HBT',ANAACT)

C /ANALYS/HISTOGRAM/BLOW - COMMAND -
      
      CALL KUCMD(' ','BLOW','C')
      GuID(1)='  Create a histogram between Min and Max on '
      GuID(2)='  x and y -axis.'
      GuID(3)='  '
      CALL KUPAR('BLOW','BLXMIN','Minimum','RO','S')
      CALL KUPVAL('BLOW','BLXMIN',0,-1.,' ','D')
      CALL KUPAR('BLOW','BLXMAX','Maximum','RO','S')
      CALL KUPVAL('BLOW','BLXMAX',0,-1.,' ','D')
      CALL KUPAR('BLOW','BLYMIN','Minimum','RO','S')
      CALL KUPVAL('BLOW','BLYMIN',0,-1.,' ','D')
      CALL KUPAR('BLOW','BLYMAX','Maximum','RO','S')
      CALL KUPVAL('BLOW','BLYMAX',0,-1.,' ','D')
      CALL KUGuID('BLOW',GuID,3,'S')
      CALL KUACT('BLOW',ANAACT)

C /ANALYS/HISTOGRAM/XBLOW - COMMAND -
      
      CALL KUCMD(' ','XBLOW','C')
      GuID(1)='  Expand a histogram using mouse in x-axis.'
      GuID(2)='  '
      CALL KUGuID('XBLOW',GuID,2,'S')
      CALL KUACT('XBLOW',ANAACT)

C /ANALYS/HISTOGRAM/XYBLOW - COMMAND -
      
      CALL KUCMD(' ','XYBLOW','C')
      GuID(1)='  Expand a histogram using mouse in x and y -axis.'
      GuID(2)='  '
      CALL KUGuID('XYBLOW',GuID,2,'S')
      CALL KUACT('XYBLOW',ANAACT)

C /ANALYS/HISTOGRAM/PRX - COMMAND -
      
      CALL KUCMD(' ','PRX','C')
      GuID(1)='  Create a histogram for projection on x-axis.'
      GuID(2)='  '
      CALL KUGuID('PRX',GuID,2,'S')
      CALL KUACT('PRX',ANAACT)

C /ANALYS/HISTOGRAM/PRY - COMMAND -
      
      CALL KUCMD(' ','PRY','C')
      GuID(1)='  Create a histogram for projection on y-axis.'
      GuID(2)='  '
      CALL KUGuID('PRY',GuID,2,'S')
      CALL KUACT('PRY',ANAACT)

C /ANALYS/HISTOGRAM/BNX - COMMAND -
      
      CALL KUCMD(' ','BNX','C')
      GuID(1)='  Create a projection onto x-axis, restricted to the '
      GuID(2)='  y interval(Ymin,Ymax).'
      GuID(3)=' '
      CALL KUPAR('BNX','YMIN','Minimum','RO','S')
      CALL KUPVAL('BNX','YMIN',0,-1.,' ','D')
      CALL KUPAR('BNX','YMAX','Maximum','RO','S')
      CALL KUPVAL('BNX','YMAX',0,-1.,' ','D')
      CALL KUGuID('BNX',GuID,3,'S')
      CALL KUACT('BNX',ANAACT)

C /ANALYS/HISTOGRAM/BNY - COMMAND -
      
      CALL KUCMD(' ','BNY','C')
      GuID(1)='  Create a projection onto y-axis, restricted to the '
      GuID(2)='  x interval(Xmin,Xmax).'
      GuID(3)=' '
      CALL KUPAR('BNY','XMIN','Minimum','RO','S')
      CALL KUPVAL('BNY','XMIN',0,-1.,' ','D')
      CALL KUPAR('BNY','XMAX','Maximum','RO','S')
      CALL KUPVAL('BNY','XMAX',0,-1.,' ','D')
      CALL KUGuID('BNY',GuID,3,'S')
      CALL KUACT('BNY',ANAACT)

C /ANALYS/HISTOGRAM/SLX - COMMAND -
      
      CALL KUCMD(' ','SLX','C')
      GuID(1)='  Create projections onto the x axis, in y-slices.'
      GuID(2)=' '
      CALL KUPAR('SLX','SNX','Number of Slices','IO','S')
      CALL KUPVAL('SLX','SNX',0,1.,' ','D')
      CALL KUGuID('SLX',GuID,2,'S')
      CALL KUACT('SLX',ANAACT)

C /ANALYS/HISTOGRAM/SLY - COMMAND -
      
      CALL KUCMD(' ','SLY','C')
      GuID(1)='  Create projections onto the y axis, in x-slices.'
      GuID(2)=' '
      CALL KUPAR('SLY','SNY','Number of Slices','IO','S')
      CALL KUPVAL('SLY','SNY',0,1.,' ','D')
      CALL KUGuID('SLY',GuID,2,'S')
      CALL KUACT('SLY',ANAACT)

C /ANALYS/HISTOGRAM/MAMI - COMMAND -
      
      CALL KUCMD(' ','MAMI','C')
      GuID(1)='  Change a limit of a current histogram on y-axis.'
      GuID(2)='  '
      CALL KUPAR('MAMI','MRYMIN','Minimum','RO','S')
      CALL KUPVAL('MAMI','MRYMIN',0,-1.,' ','D')
      CALL KUPAR('MAMI','MRYMAX','Maximum','RO','S')
      CALL KUPVAL('MAMI','MRYMAX',0,-1.,' ','D')
      CALL KUGuID('MAMI',GuID,2,'S')
      CALL KUACT('MAMI',ANAACT)

C /ANALYS/HISTOGRAM/XSTATUS - COMMAND -
      
      CALL KUCMD(' ','XSTATUS','C')
      GuID(1)='  Print status of a given histogram.'
      GuID(2)='  '
      CALL KUGuID('XSTATUS',GuID,2,'S')
      CALL KUACT('XSTATUS',ANAACT)

C /ANALYS/HISTOGRAM/HSTATUS - COMMAND -
      
      CALL KUCMD(' ','HSTATUS','C')
      GuID(1)='  Print definitions of a current histogram.'
      GuID(2)='  '
      CALL KUGuID('HSTATUS',GuID,2,'S')
      CALL KUACT('HSTATUS',ANAACT)

C /ANALYS/HISTOGRAM/HLIST - COMMAND -
      
      CALL KUCMD(' ','HLIST','C')
      GuID(1)='  Print List of all Histograms with Display Format.'
      GuID(2)='  '
      CALL KUPAR('HLIST','CHOPT','Options ','OO','S')
      CALL KUPVAL('HLIST','CHOPT',0,0.,' ','D')
      CALL KUPVAL('HLIST','CHOPT',0,0.,'P','V')
      CALL KUPVAL('HLIST','CHOPT',0,0.,'   Pager Mode','-P')
      CALL KUGuID('HLIST',GuID,2,'S')
      CALL KUACT('HLIST',ANAACT)

C /ANALYS/HISTOGRAM/XFITG - COMMAND -
      
      CALL KUCMD(' ','XFITG','C')
      GuID(1)='  Fit a current Histogram using a Gaussian Function.'
      GuID(2)='  '
      CALL KUGuID('XFITG',GuID,2,'S')
      CALL KUACT('XFITG',ANAACT)

C /ANALYS/HISTOGRAM/FIGA - COMMAND -
      
      CALL KUCMD(' ','FIGA','C')
      GuID(1)='  Fit a current Histogram using a Gaussian Function.'
      GuID(2)='  '
      CALL KUGuID('FIGA',GuID,2,'S')
      CALL KUACT('FIGA',ANAACT)

C /ANALYS/HISTOGRAM/HDELETE - COMMAND -
      
      CALL KUCMD(' ','HDELETE','C')
      GuID(1)='  Delete a current or given Histograms.'
      GuID(2)='  HID1 = 0 & HID2 = 0 : current Histogram.'
      GuID(3)=' '
      CALL KUPAR('HDELETE','HID1','First Histogram ID','IO','S')
      CALL KUPVAL('HDELETE','HID1',0,0.,' ','D')
      CALL KUPAR('HDELETE','HID2','Second Histogram ID','IO','S')
      CALL KUPVAL('HDELETE','HID2',0,0.,' ','D')
      CALL KUGuID('HDELETE',GuID,3,'S')
      CALL KUACT('HDELETE',ANAACT)

C /ANALYS/HISTOGRAM/ERASE - COMMAND -
      
      CALL KUCMD(' ','ERASE','C')
      GuID(1)='  Erase Histogram contents and EVS.'
      GuID(2)='  '
      CALL KUGuID('ERASE',GuID,2,'S')
      CALL KUACT('ERASE',ANAACT)

C /ANALYS/HISTOGRAM/XVAL - COMMAND -
      
      CALL KUCMD(' ','XVAL','C')
      GuID(1)='  Print channel contents of a given bin in x-axis.' 
      GuID(2)='  '
      CALL KUGuID('XVAL',GuID,2,'S')
      CALL KUACT('XVAL',ANAACT)

C /ANALYS/HISTOGRAM/XYVAL - COMMAND -
      
      CALL KUCMD(' ','XYVAL','C')
      CALL KUPAR('XYVAL','CHOPT','Options ','OO','S')
      CALL KUPVAL('XYVAL','CHOPT',0,0.,' ','D')
      CALL KUPVAL('XYVAL','CHOPT',0,0.,' ,S','V')
      CALL KUPVAL('XYVAL','CHOPT',0,0.,'   Histogram Mode','- ')
      CALL KUPVAL('XYVAL','CHOPT',0,0.,'   Scatter Mode','-S')
      GuID(1)='  Print contents of a given bin in x and y axis.' 
      GuID(2)='  '
      CALL KUGuID('XYVAL',GuID,2,'S')
      CALL KUACT('XYVAL',ANAACT)

C /ANALYS/HISTOGRAM/CPRO - COMMAND -
      
      CALL KUCMD(' ','CPRO','C')
      CALL KUPAR('CPRO','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('CPRO','HID',0,0.,' ','D')
      CALL KUPAR('CPRO','COPT','Window Option','CO','S')
      CALL KUPVAL('CPRO','COPT',0,0.,'M','D')
      CALL KUPVAL('CPRO','COPT',0,0.,'M,S,OPT','V')
      CALL KUPVAL('CPRO','COPT',0,0.,'   Main Window','-M')
      CALL KUPVAL('CPRO','COPT',0,0.,'   Scatter Window','-S')
      CALL KUPVAL('CPRO','COPT',0,0.,'   HPLOT Option','-OPT')
      GuID(1)='  Project Contents to 2D-Hist gated with cut.'
      GuID(2)='  '
      CALL KUGuID('CPRO',GuID,2,'S')
      CALL KUACT('CPRO',ANAACT)

C /ANALYS/HISTOGRAM/AVY - COMMAND -
      
      CALL KUCMD(' ','AVY','C')
      CALL KUPAR('AVY','HID','Histogram ID  ','IO','S')
      CALL KUPVAL('AVY','HID',0,0.,' ','D')
      CALL KUPAR('AVY','COPT','Option','CO','S')
      CALL KUPVAL('AVY','COPT',0,0.,' ','D')
      CALL KUPVAL('AVY','COPT',0,0.,' ,S,I','V')
      CALL KUPVAL('AVY','COPT',0,0.,'   Default','-')
      CALL KUPVAL('AVY','COPT',0,0.,'   Spread Option','-S')
      CALL KUPVAL('AVY','COPT',0,0.,'   Error on Mean','-I')
      GuID(1)='  Project Contents to a profile histogram.'
      GuID(2)='  '
      CALL KUGuID('AVY',GuID,2,'S')
      CALL KUACT('AVY',ANAACT)

C /ANALYS/HISTOGRAM/CDRAW - COMMAND -
      
      CALL KUCMD(' ','CDRAW','C')
      CALL KUPAR('CDRAW','CUTID','CUT ID  ','IO','S')
      CALL KUPVAL('CDRAW','CUTID',0,0.,' ','D')
      CALL KUPAR('CDRAW','CUTNAME','Cut File name','CO','S')
      CALL KUPVAL('CDRAW','CUTNAME',0,0.,' ','D')
      CALL KUPAR('CDRAW','COPT','Window Option','CO','S')
      CALL KUPVAL('CDRAW','COPT',0,0.,'M','D')
      CALL KUPVAL('CDRAW','COPT',0,0.,'M,S,OPT','V')
      CALL KUPVAL('CDRAW','COPT',0,0.,'   Main Window','-M')
      CALL KUPVAL('CDRAW','COPT',0,0.,'   Scatter Window','-S')
      CALL KUPVAL('CDRAW','COPT',0,0.,'   HPLOT Option','-OPT')
      GuID(1)='  Draw cut-line on 2D-Hist.'
      GuID(2)='  '
      CALL KUGuID('CDRAW',GuID,2,'S')
      CALL KUACT('CDRAW',ANAACT)

C /ANALYS/HISTOGRAM/CHBIN - COMMAND -
      
      CALL KUCMD(' ','CHBIN','C')
      CALL KUPAR('CHBIN','BF','Bin Factor  ','IO','S')
      CALL KUPVAL('CHBIN','BF',1,0.,' ','D')
      GuID(1)=' The specified channels of the 1-Dim histogram '//
     &        'ID1 are cumulated (rebinned) '//
     &        'into new bins of 1-Dim histogram ID2.'
      GuID(2)=' The final contents of the new bin is THE SUM '//
     &        'of the original bins.'
      CALL KUGuID('CHBIN',GuID,2,'S')
      CALL KUACT('CHBIN',ANAACT)

C /ANALYS/HISTOGRAM/GPRO - COMMAND -
      
      CALL KUCMD(' ','GPRO','C')
      CALL KUPAR('GPRO','CUTID','CUT ID  ','IO','S')
      CALL KUPVAL('GPRO','CUTID',0,0.,' ','D')
      CALL KUPAR('GPRO','CUTNAME','Cut File name','CO','S')
      CALL KUPVAL('GPRO','CUTNAME',0,0.,' ','D')
      CALL KUPAR('GPRO','COPT','Window Option','CO','S')
      CALL KUPVAL('GPRO','COPT',0,0.,'M','D')
      CALL KUPVAL('GPRO','COPT',0,0.,'M,S,OPT','V')
      CALL KUPVAL('GPRO','COPT',0,0.,'   Main Window','-M')
      CALL KUPVAL('GPRO','COPT',0,0.,'   Scatter Window','-S')
      CALL KUPVAL('GPRO','COPT',0,0.,'   HPLOT Option','-OPT')
      GuID(1)='  Project Contents to 2D-Hist gated with cut.'
      GuID(2)='  '
      CALL KUGuID('GPRO',GuID,2,'S')
      CALL KUACT('GPRO',ANAACT)

      CALL KUCMD('..',' ','SW')

c /ANALYS/LOOP - COMMAND -

      CALL KUCMD(' ','LOOP','C')
      CALL KUPAR('LOOP','RDFNAME','Raw Data File name','CO','S')
      CALL KUPVAL('LOOP','RDFNAME',0,0.,'ONLINE','D')
      CALL KUPAR('LOOP','CHOPT','Options ','OO','S')
      CALL KUPVAL('LOOP','CHOPT',0,0.,' ','D')
      CALL KUPVAL('LOOP','CHOPT',0,0.,' ,B','V')
      CALL KUPVAL('LOOP','CHOPT',0,0.,'   Command Mode','- ')
      CALL KUPVAL('LOOP','CHOPT',0,0.,'   Batch Mode','-B')
      CALL KUPAR('LOOP','NUM','Number of loops  ','IO','S')
      CALL KUPVAL('LOOP','NUM',0,0.,' ','D')
      CALL KUPAR('LOOP','REFTIME',
     &           'Reflesh time for next update ','RO','S')
      CALL KUPVAL('LOOP','REFTIME',0,4.,' ','D')

      GuID(1)=' This command provides you to see the histograms '//
     &'(1D and 2D-Histograms). For the 2D-Histogram, '//
     &'it is shown by using SCATTER-PLOT.'
      GuID(2)=' You can select number of events to do following '//
     &'expression.'
      GuID(3)=' '
      GuID(4)=' ANAPAW> analys/loop filename ! 100000 5.' 
      GuID(5)=' '
      GuID(6)=' The BATCH-MODE is available, it has no updating '//
     &'histograms.'
      GuID(7)=' ANAPAW> analys/loop filename B 100000 '
      GuID(8)=' '
      GuID(9)=' If filename = ONLINE(Default), LOOP gets data '//
     &'from some event generator.'
      GuID(10)=' '
      GuID(11)=' LOOP has a internal Shell - EVTLOOP -. '
      GuID(12)=' For more details, use help command in EVTLOOP.'
      CALL KUGuID('LOOP',GuID,12,'S')
      CALL KUACT('LOOP',ANAACT)

C /ANALYS/STATUS - COMMAND -
      
      CALL KUCMD(' ','STATUS','C')
      GuID(1)=' Print Current Status.'
      GuID(2)='  '
      GuID(3)='  Print Current Status.'
      GuID(4)=' Scaler, RDF, ANA, Analyser, etc.'
      CALL KUGuID('STATUS',GuID,4,'S')
      CALL KUACT('STATUS',ANAACT)

C /ANALYS/RDMP - COMMAND -
      
      CALL KUCMD(' ','RDMP','C')
      CALL KUPAR('RDMP','FIO','Open/Close ','OO','S')
      CALL KUPVAL('RDMP','FIO',0,0.,'O','D')
      CALL KUPVAL('RDMP','FIO',0,0.,'O,C,M','V')
      CALL KUPVAL('RDMP','FIO',0,0.,'   Open File.','-O')
      CALL KUPVAL('RDMP','FIO',0,0.,'   Close File.','-C')
      CALL KUPVAL('RDMP','FIO',0,0.,'   Make Header for a buffer.','-M')
      CALL KUPAR('RDMP','DMPNAME','Raw Data File name','CO','S')
      CALL KUPVAL('RDMP','DMPNAME',0,0.,'anadump.rdf','D')
      CALL KUPAR('RDMP','GID','Gate ID ','IO','S')
      CALL KUPVAL('RDMP','GID',0,0.,' ','D')
      GuID(1)=' Store the Raw Data to a file with a given Gate.'
      GuID(2)='  '
      CALL KUGuID('RDMP',GuID,2,'S')
      CALL KUACT('RDMP',ANAACT)

C /ANALYS/ANTUPLE - COMMAND -
      
      CALL KUCMD(' ','ANTUPLE','C')
      CALL KUPAR('ANTUPLE','FIO','Open/Close ','OO','S')
      CALL KUPVAL('ANTUPLE','FIO',0,0.,'O','D')
      CALL KUPVAL('ANTUPLE','FIO',0,0.,'O,C','V')
      CALL KUPVAL('ANTUPLE','FIO',0,0.,'   Open File.','-O')
      CALL KUPVAL('ANTUPLE','FIO',0,0.,'   Close File.','-C')
      CALL KUPAR('ANTUPLE','GID','Gate ID ','IO','S')
      CALL KUPVAL('ANTUPLE','GID',0,0.,' ','D')
      CALL KUPAR('ANTUPLE','RunNum','Run Number ','IO','S')
      CALL KUPVAL('ANTUPLE','RunNum',1,0.,' ','D')
      GuID(1)='  Store the Raw Data to Ntuple files with a given Gate.'
      GuID(2)='  '
      CALL KUGuID('ANTUPLE',GuID,2,'S')
      CALL KUACT('ANTUPLE',ANAACT)

C /ANALYS/UFLAG - COMMAND -
      
      CALL KUCMD(' ','UFLAG','C')
      CALL KUPAR('UFLAG','FLID','Flag ID ','IO','S')
      CALL KUPVAL('UFLAG','FLID',0,0.,' ','D')
      CALL KUPAR('UFLAG','FLAG','TRUE/FALSE ','CO','S')
      CALL KUPVAL('UFLAG','FLAG',0,0.,'T','D')
      CALL KUPVAL('UFLAG','FLAG',0,0.,'T,F','V')
      CALL KUPVAL('UFLAG','FLAG',0,0.,'   User Flag TRUE','-T')
      CALL KUPVAL('UFLAG','FLAG',0,0.,'   User Flag FALSE','-F')
      CALL KUPAR('UFLAG','GID','Gate ID ','IO','S')
      CALL KUPVAL('UFLAG','GID',0,0.,' ','D')
      GuID(1)='  Change User Flag defined in ENC_***.'
      GuID(2)=' You can take FLID value from 1 to 10. '
      GuID(3)=' '
      CALL KUGuID('UFLAG',GuID,3,'S')
      CALL KUACT('UFLAG',ANAACT)

C /ANALYS/SETNUMBER - COMMAND -
      
      CALL KUCMD(' ','SETNUMBER','C')
      GuID(1)='  Set Run Number of a current data file. '
      GuID(2)=' This command is useful for RDMP file created on '
      GuID(3)=' anapaw version before 2.2.5.'
      GuID(4)=' '
      CALL KUPAR('SETNUMBER','RNUM','Run Number','IO','S')
      CALL KUPVAL('SETNUMBER','RNUM',0,0.,' ','D')
      CALL KUGuID('SETNUMBER',GuID,4,'S')
      CALL KUACT('SETNUMBER',ANAACT)

      CALL KUCMD('..',' ','SW')

      CALL KUCMD('/',' ','SW')
 
      Return

      End
