/* $Id:$ */
/**
 * @file   TArtSharedMemoryDataSource.cc
 * @date   Created : Mar 29, 2008 15:29:01 JST
 *   Last Modified : Dec 04, 2008 22:29:52 JST
 * @author RIPS Taro <rips@entrance.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#include "TArtSharedMemoryDataSource.h"
#include "TArtRDF.h"
#include "TArtRIDF.h"
#include "TArtCore.h"
#include <stdio.h>
#include <unistd.h>

TArtDataSource* TArtSharedMemoryDataSource::fgInstance = 0;
TArtSharedMemoryDataSource::TArtSharedMemoryDataSource()
   : fSharedMemory(0), fSemaphore(0), fNBlock(0), fMemoryPos(0),
     fIsOpen(0), fSharedMemoryID(0)
{
}

TArtSharedMemoryDataSource::~TArtSharedMemoryDataSource()
{
  Close();
   fgInstance = 0;
}

TArtDataSource *TArtSharedMemoryDataSource::Instance() {
   if (!fgInstance) {
      fgInstance = new TArtSharedMemoryDataSource;
   }
   return fgInstance;
}

int TArtSharedMemoryDataSource::Open(const char* sourceName) {
   int shmkey = ANSHMKEY + fSharedMemoryID*2;
   int semkey = ANSEMKEY + fSharedMemoryID*2;
   Close();
#ifdef DEBUG
   printf("\n");
   TArtCore::Info("TArtSharedMemoryDataSource","Open : shmid = %d",fSharedMemoryID);
   TArtCore::Info("TArtSharedMemoryDataSource","Open : shmkey = %d",shmkey);
   TArtCore::Info("TArtSharedMemoryDataSource","Open : semkey = %d",semkey);
   printf("\n");
#endif

   fRunNumber = 0;
   fSharedMemory = new TArtSharedMemory(shmkey,(SHM_BUFF_SIZE+4));

   if (!fSharedMemory->IsValid()) {
      Close();
      return (fFileStatus = kNOTEXIST);
   }
   fSemaphore = new TArtSemaphore(semkey);
   if (!fSemaphore->IsValid()) {
      Close();
      return (fFileStatus = kNOTEXIST);
   }
   fMemoryPos = 0;
   fNBlock = 0;
   fIsOpen = true;
   return (fFileStatus = kEXIST);
}

void TArtSharedMemoryDataSource::Close() {
  if (fSharedMemory) {
    delete fSharedMemory;
    fSharedMemory = 0;
  }
  if (fSemaphore) {
    delete fSemaphore;
    fSemaphore = 0;
  }
  fIsOpen = false;
}

int TArtSharedMemoryDataSource::Seek(long offset, int origin) 
{
   switch (origin) {
   case SEEK_SET:
      fMemoryPos = offset;
      break;
   case SEEK_CUR:
      fMemoryPos += offset;
      break;
   case SEEK_END:
      fMemoryPos = fSharedMemory->GetSize() - offset;
      break;
   default:
      return -1;
   }
   return 0;
}
int TArtSharedMemoryDataSource::Read(char *buf, const int& size, const int& offset) 
{
  if (offset) fMemoryPos = offset;
    int len = fSharedMemory->Read(buf,size,fMemoryPos);
   fMemoryPos += size;
   return len;
}

int TArtSharedMemoryDataSource::IsPrepared()
{
  unsigned int nblock;

  if (!fSemaphore)  return 0;
  usleep(1);
  fSemaphore->Lock();
  fMemoryPos = 0;
  Read((char*)&nblock,sizeof(int),SHM_BUFF_SIZE);
  if (nblock == fNBlock) {
    fSemaphore->Unlock();
    return 0;
  }
  fNBlock = nblock;
  fMemoryPos = 0;
  return 1;
}

int TArtSharedMemoryDataSource::Wait() {
  fSemaphore->Unlock();
}

#include <iostream>
using namespace std;
ArtBlockStat_t TArtSharedMemoryDataSource::GetNextBlock() {
   unsigned int nblock;

   if (!fSemaphore) return kERRORBLOCK;
   
   usleep(1);
   fSemaphore->Lock();
   fSharedMemory->Read((char*)&nblock,sizeof(int),SHM_BUFF_SIZE);
   if (nblock==fNBlock) {
      fBlockStatus = kWAIT;
      cout << "kwait" << endl;
   } else {
      cout << "<TArtSharedMemoryDataSource::GetNextBlock()> fNBlock=" 
           << fNBlock << endl;
      fNBlock = nblock;
      ArtRidfHeader_t header;
      Read((char*)&header,sizeof(header));
      fMemoryPos = 0;
      if (header.BIT.fAddress != 0) {
         fFormat = TArtRIDF::Instance();
      } else {
         fFormat = TArtRDF::Instance();
      }
      if (fFormat) fBlockStatus = fFormat->GetNextBlock(this);
      fMemoryPos = 0;
   }
   fSemaphore->Unlock();
   return fBlockStatus;
}

void TArtSharedMemoryDataSource::SetSharedMemoryID(int shmid)
{
   if (shmid > kfMaxSharedMemoryID) {
      TArtCore::Info("TArtSharedMemoryDataSource","SetSharedMemoryID : ID = %d exceeds maximum id (%d)",shmid,kfMaxSharedMemoryID);
      exit(1);
   }
   TArtCore::Info("TArtSharedMemoryDataSource","SetSharedMemoryID : ID = %d",shmid);
   fSharedMemoryID = shmid;
   if (fIsOpen) {
      Close();
      Open(NULL);
   }
}

int TArtSharedMemoryDataSource::GetSharedMemoryID()
{
   return fSharedMemoryID;
}

void setshmid_(int *shmid) {
   ((TArtSharedMemoryDataSource*)TArtSharedMemoryDataSource::Instance())->SetSharedMemoryID(*shmid);
}
void getshmid_(int *shmid) {
   *shmid = ((TArtSharedMemoryDataSource*)TArtSharedMemoryDataSource::Instance())->GetSharedMemoryID();
}

