/*
 *    TArtParser.h
 *    Created       : 2008/09/26 13:54:03 JST
 *    Last Modified : 2008/10/30 21:37:52 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA
 */
#ifndef TARTPARSER_H
#define TARTPARSER_H
#include "TArtDataSource.h"
#include "TArtMapConfig.h"
class TArtParser {
public:
   static const int kMaxBufLen;
   virtual ~TArtParser();
   virtual void Parse(TArtDataSource *source,TArtMapConfig *mapConfig);
   virtual int CopyPrevEvent(char *dest) = 0;
protected:
   virtual void GetNextBlock(TArtDataSource *source) = 0;
   virtual void GetNextEvent(TArtMapConfig *mapConfig) = 0;
   unsigned char *fBlockBuffer;
   int fOffset;
   int fNext;
   int fPrev;
   int fBlockSize;
   bool fEOB;
   bool fEOF;
protected:
   TArtParser();
   TArtParser(const TArtParser&) {;}
   TArtParser& operator=(const TArtParser&) {;}
};
#endif // end of #ifdef TARTPARSER_H
