/* $Id:$ */
/**
 * @file   TArtFileDataSource.cc
 * @date   Created : Mar 29, 2008 16:29:43 JST
 *   Last Modified : 2009/01/19 13:31:26 JST
 * @author RIPS Taro <rips@entrance.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#include <stdlib.h>
#include "TArtFileDataSource.h"
#include "TArtRDF.h"
#include "TArtRIDF.h"
#include "TArtCore.h"
#include <string.h>

/* Size */
#define RIDF_COMMENT_RUNINFO_ASC_SIZE   1024

/** RIDF comment header structure */
struct ridf_comment_runinfost{
  char runname[100];
  char runnumber[100];
  char starttime[20];
  char stoptime[20];
  char date [20];
  char rev[40];
  char header[100];
  char ender[100];
};


TArtDataSource* TArtFileDataSource::fgInstance = 0;
TArtFileDataSource::TArtFileDataSource()
: fFile(0) {
}
TArtFileDataSource::~TArtFileDataSource()
{
}

TArtDataSource* TArtFileDataSource::Instance() 
{
   if (!fgInstance) {
      fgInstance = new TArtFileDataSource;
   } 
   return fgInstance;
}
         

int TArtFileDataSource::Open(const char* sourceName) 
{
   if (!sourceName) return (fFileStatus = kNOTEXIST);
   if (stat(sourceName,&fFileStat)) return (fFileStatus = kNOTEXIST);
   if (fFile) fclose(fFile);
   fFile = fopen(sourceName,"rb"); 
   if (!fFile) {
     printf("<TArtFileDataSource::Open> unexpected error at line %d\n",
	    __LINE__);
     return kNOTEXIST;
   }
   TArtCore::Info("TArtFileDataSource","File = %s",sourceName);
   TArtCore::Info("TArtFileDataSource","Size = %5.2f (MB)",
                  fFileStat.st_size/1024./1024.);
   long pos = ftell(fFile);
   unsigned int header[2];
   char buff[RIDF_COMMENT_RUNINFO_ASC_SIZE];
   struct ridf_comment_runinfost info;
   char start[20], stop[20];

   fRunNumber = 0;
   fread((char*)header,sizeof(int),2,fFile);
   if (header[1]!=0) {
      // RIDF format
      fFormat = TArtRIDF::Instance();
      TArtCore::Info("TArtFileDataSource","Format = RIDF");

      fread((char*)header,sizeof(int),2,fFile);
      if(((header[0]>>22)&0x3f) == 5){
	fread((char*)header,sizeof(int),2,fFile);

	if(header[1] == 1){
	  fread((char *)&info, 1, sizeof(info), fFile);
	  memset(start, 0, sizeof(start));
	  memset(stop, 0, sizeof(stop));
	
	  memcpy(start, info.starttime+9, sizeof(start)-9);
	  memcpy(stop, info.stoptime+8, sizeof(stop)-8);
	  
	  TArtCore::Info("TArtFileDataSource","Run name   = %s", info.runname);
	  TArtCore::Info("TArtFileDataSource","Run number = %s", info.runnumber);
	  TArtCore::Info("TArtFileDataSource","Start time = %s", start);
	  TArtCore::Info("TArtFileDataSource","Stop time  = %s", stop);
	  TArtCore::Info("TArtFileDataSource","Date       = %s", info.date);
	  TArtCore::Info("TArtFileDataSource","Header     = %s", info.header);
	  TArtCore::Info("TArtFileDataSource","Ender      = %s", info.ender);
	  
	  fRunNumber = strtol(info.runnumber, NULL, 10);
	}
      }

   } else {
      fFormat = TArtRDF::Instance();
      TArtCore::Info("TArtFileDataSource","Format = RDF");
   }
   
   fseek(fFile,pos,0);
   return (fFileStatus = kEXIST);
}


void TArtFileDataSource::Close() 
{
   if (fFile) fclose(fFile);
   fFile = 0;
   fFileStatus = kNOTEXIST;
}

int TArtFileDataSource::Seek(long offset, int origin) 
{
   if (!fFile) return -1;
   return fseek(fFile,offset,origin);
}
   

int TArtFileDataSource::Read(char *buf, const int &size, const int & /* offset */)
{
   if (!fFile) return 0;
   return fread(buf,sizeof(char),size,fFile);
}

//ArtBlockStat_t TArtFileDataSource::GetNextBlock() {
////   printf("<TArtFileDataSource::GetNextBlock> get block with fFormat at %p\n",
////          fFormat);
////   printf("<TArtFileDataSource::GetNextBlock> with this at %p\n",this);
////   printf("<TArtFileDataSource::GetNextBlock> fFormat at %p\n",fFormat);
//   return fFormat->GetNextBlock(this);
//}
  
