/*
 * @file TArtEventStatus.h
 * @date  Created : 2008/10/20 22:02:36 JST<BR>
 *  Last Modified : 2008/10/21 10:40:14 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */

#include <stdio.h>

#ifndef TARTEVENTSTATUS_H
#define TARTEVENTSTATUS_H
extern "C" {
   typedef struct {
      int fileend;
      int erflag;
      int evtwnum;
      int blkc;
      int trignum;
   } anaevtstat_t;
   extern anaevtstat_t anaevtstat_; 
}

class TArtEventStatus  {
public:
   static TArtEventStatus* Instance();
   ~TArtEventStatus();
   void SetFileEnd(int rhs) { anaevtstat_.fileend = rhs; }
   void SetERFlag(int rhs) { anaevtstat_.erflag = rhs; }
   void SetEvtWnum(int rhs) { anaevtstat_.evtwnum = rhs; }
   int GetFileEnd() { return anaevtstat_.fileend; }
   void AddBlkCnt() { anaevtstat_.blkc++; }
   void AddTrigNum() { anaevtstat_.trignum++; }
private:
   TArtEventStatus();
   TArtEventStatus(const TArtEventStatus&) {;}
   TArtEventStatus& operator=(const TArtEventStatus&) {;}

};
#endif // end of #ifdef TARTEVENTSTATUS_H
