/*
 *    ARTDumpRIDF.hh
 *    Created       : 
 *    Last Modified : 
 *--------------------------------------------------------
 *    Comment : DumpRIDF is rdump for RIDF
 *    
 *--------------------------------------------------------
 *    Copyright (C)2007-2008 by H.Baba
 */
#ifndef TARTDUMPRIDF_H
#define TARTDUMPRIDF_H

#include <stdio.h>
#include <string.h>
#include <fstream>
#include "TArtParser.h"
#include "TArtEventStore.h"
using namespace std;

#define MAXFILENAME 1024
#define MB 1048576 // Unit of MByte (1024*1024)
#define MAXBLOCKSIZE 131072 // maximum block size 128kByte
#define WORDSIZE 2 // Byte

// for anapaw compatible
#ifdef __cplusplus
extern "C" {
#endif
  void open_dumpfile__(char name[132], int* fnamelen, int* flag,int *mx);
  void mkheader_dumpfile__();
  void close_dumpfile__();
  void add_event__(unsigned short edata[],int *rnum);
#ifdef __cplusplus
}
#endif

/** TArtDumpRIDF
 *
 *
 */
class TArtDumpRIDF {
public:
   ~TArtDumpRIDF();
   static TArtDumpRIDF *Instance();
   int Open(const char *filename = 0);
   void AddEvent();
   void Close();   
   void Clear();
   void Initialize();
   void WriteHeader();
private:
   TArtParser       *fParserRIDF;
   bool fBlock;
   bool fIsInitialied;
   int fMaxevt;
   int fPrevRunNumber;
   int fDumpBuffIdx;
   char fDumpBuff[64*1024];  // 64kB buffer
   static TArtDumpRIDF *fgDumpRIDF;
private:
   TArtDumpRIDF();
   TArtDumpRIDF(const TArtDumpRIDF&) {;}
};
#endif // end of #ifdef TARTDUMPRIDF_H
