/*
 *    TArtDumpRIDF.cc
 *    Created       : 
 *    Last Modified : 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2009 by H. Baba
 */
#include "TArtCore.h"
#include "TArtDumpRIDF.h"
#include "TArtParserRIDF.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

TArtDumpRIDF* TArtDumpRIDF::fgDumpRIDF = 0;


/*
 Definition for RIDF
 from ribf.h@babirl
*/
/* Macros */
#define RIDF_MKHD1(a,b,c) ((a&0x3)<<28|(b&0x3f)<<22|(c&0xffffff))
#define RIBF_MKHD2(d)      (d & 0xffffffff)
/* Bits */
#define RIDF_LY0               0
#define RIDF_LY1               1
#define RIDF_LY2               2
#define RIDF_LY3               3

/* Class ID */
#define RIDF_EF_BLOCK          0
#define RIDF_EA_BLOCK          1
#define RIDF_EAEF_BLOCK        2
#define RIDF_EVENT             3
#define RIDF_SEGMENT           4
#define RIDF_COMMENT           5
#define RIDF_SCALER            11
#define RIDF_CSCALER           12
#define RIDF_STATUS            21

/* Comment ID */
#define RIDF_COMMENT_TEXT        0
#define RIDF_COMMENT_RUNINFO_ASC 1
#define RIDF_COMMENT_EFINFO_ASC  2
#define RIDF_COMMENT_DAQINFO_BIN 3
#define RIDF_COMMENT_RUNINFO_BIN 4
/* Size */
#define RIDF_COMMENT_RUNINFO_ASC_SIZE   1024

struct ridf_hdst{
  int hd1; // First 2 words for layer, classid, blksize
  int hd2; // Second 2 words for efn
};

FILE *fd = NULL;

//////////////////////////////////////////////////
//

TArtDumpRIDF::TArtDumpRIDF()
  : fParserRIDF(0), fIsInitialied(false)
{
  TArtCore::Info("TArtDumpRIDF","Constructor");
}

TArtDumpRIDF::~TArtDumpRIDF()
{
}

void TArtDumpRIDF::Clear() 
{
  fIsInitialied = false;
}

void TArtDumpRIDF::Initialize()
{
  if (fIsInitialied) return;

  fgDumpRIDF->WriteHeader();
  fIsInitialied = true;
}


TArtDumpRIDF* TArtDumpRIDF::Instance()
{
  if (!fgDumpRIDF) fgDumpRIDF = new TArtDumpRIDF();
  return fgDumpRIDF;
}


int TArtDumpRIDF::Open(const char *filename)
{
  int ret = 0;

  fMaxevt = 16000;  // ~32kB block size
  fBlock = false;

  if((fd = fopen(filename, "r")) != NULL){
    fclose(fd);
    fd = NULL;
    ret = 1;
  }else{
    fd = fopen(filename, "w");
    ret = 0;
  }

  return ret;
}
//fParser = TArtParserFactory::Create(fDataSource);

void TArtDumpRIDF::Close()
{
  if(fBlock){
    struct ridf_hdst hd;
    // Global Header 
    hd.hd1 = RIDF_MKHD1(RIDF_LY0, RIDF_EA_BLOCK, sizeof(hd)/2 + fDumpBuffIdx);
    hd.hd2 = 1; // Dummy EF Number
    fwrite((char *)&hd, 1, sizeof(hd), fd);
    fwrite(fDumpBuff, sizeof(short), fDumpBuffIdx, fd);
    fBlock = false;
  }

  if(fd) fclose(fd);
  TArtDumpRIDF::Instance()->Clear();
}

void TArtDumpRIDF::AddEvent()
{
  int size;

  if(fPrevRunNumber != anarunstat_.rnumber){
    fgDumpRIDF->WriteHeader();
  }

  if(!fBlock){
    fDumpBuffIdx = 0;
    fBlock = true;
  }

  fParserRIDF = TArtParserRIDF::Instance();
  size = fParserRIDF->CopyPrevEvent(fDumpBuff+(fDumpBuffIdx*2));
  fDumpBuffIdx += size/2;

  if(fDumpBuffIdx > fMaxevt){
    struct ridf_hdst hd;
    // Global Header 
    hd.hd1 = RIDF_MKHD1(RIDF_LY0, RIDF_EA_BLOCK, sizeof(hd)/2 + fDumpBuffIdx);
    hd.hd2 = 1; // Dummy EF Number
    fwrite((char *)&hd, 1, sizeof(hd), fd);
    fwrite(fDumpBuff, sizeof(short), fDumpBuffIdx, fd);
    fBlock = false;
  }
}

void TArtDumpRIDF::WriteHeader()
{

  // Write residual data
  if(fBlock){
    struct ridf_hdst hd;
    // Global Header 
    hd.hd1 = RIDF_MKHD1(RIDF_LY0, RIDF_EA_BLOCK, sizeof(hd)/2 + fDumpBuffIdx);
    hd.hd2 = 1; // Dummy EF Number
    fwrite((char *)&hd, 1, sizeof(hd), fd);
    fwrite(fDumpBuff, sizeof(short), fDumpBuffIdx, fd);
    fBlock = false;
  }

  /* Store previous runnumber */
  fPrevRunNumber = anarunstat_.rnumber;

  if(anarunstat_.rnumber > 0 && fd != NULL){
    /* Make header block */
    char runch[RIDF_COMMENT_RUNINFO_ASC_SIZE];
    struct ridf_hdst hd;
    time_t t;
    int val, idx;

    memset(runch, 0, sizeof(runch));
    // Global Header 
    hd.hd1 = RIDF_MKHD1(RIDF_LY0, RIDF_EA_BLOCK, (sizeof(runch)+sizeof(hd))/2);
    hd.hd2 = 1; // Dummy EF Number
    fwrite((char *)&hd, 1, sizeof(hd), fd);

    // Comment Header
    hd.hd1 = RIDF_MKHD1(RIDF_LY1, RIDF_COMMENT, sizeof(runch)/2);
    hd.hd2 = 1; // Dummy EF Number
    memcpy(runch, (char *)&hd, sizeof(hd));
    idx = sizeof(hd);

    // Time
    time(&t);
    val = (int)t;
    memcpy(runch+idx, (char *)&val, sizeof(val));
    idx += sizeof(val);

    // Comment ID
    val = RIDF_COMMENT_RUNINFO_ASC;
    memcpy(runch+idx, (char *)&val, sizeof(val));
    idx += sizeof(val);

    sprintf(runch+idx, "%s", "rdmprun");
    idx += 100;
    sprintf(runch+idx, "%04d", anarunstat_.rnumber);
    idx += 100;
    sprintf(runch+idx, "START => XX:XX:XX");
    idx += 20;
    sprintf(runch+idx, "STOP => XX:XX:XX");
    idx += 20;
    sprintf(runch+idx, "00-RMP-00");
    idx += 60;
    sprintf(runch+idx, "Generated by rdmp");
    idx += 100;
    sprintf(runch+idx, "Generated by rdmp");

    fwrite((char *)&runch, 1, sizeof(runch), fd);
  }
}


//ArtEventStat_t TArtDumpRIDF::GetNextEvent()
//{
  //TArtRawDataAllocator::Instance()->ClearData();
  //fParser->Parse(fDataSource,fMapConfig);
//}
   

///////////////////////////////////////////////////////////////////////////
// anapaw compatible function
///////////////////////////////////////////////////////////////////////////
void open_dumpfile__(char name[132], int* fnamelen, int* flag,int *mx){
  char filename[256];
  memset(filename, 0, sizeof(filename));
  strncpy(filename, name, *fnamelen);

  printf("open dumpfile %s\n", name);

  TArtDumpRIDF *dump = TArtDumpRIDF::Instance();
  *flag = dump->Open(filename);
}

void mkheader_dumpfile__(){
}
void close_dumpfile__(){
  TArtDumpRIDF::Instance()->Initialize();
  TArtDumpRIDF::Instance()->Close();
}
void add_event__(unsigned short edata[],int *rnum){
  TArtDumpRIDF::Instance()->Initialize();
  TArtDumpRIDF::Instance()->AddEvent();
}

