/*
 * @file TArtDecoderTimeStamp.cc
 * @date  Created : 2008/10/29 48:08:53 JST<BR>
 *  Last Modified : 2008/10/30 23:59:31 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderTimeStamp.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"

TArtDecoderTimeStamp::TArtDecoderTimeStamp()
   : TArtDecoder(kID) {
}

TArtDecoderTimeStamp::~TArtDecoderTimeStamp()
{
}

TArtDecoder* TArtDecoderTimeStamp::Instance()
{
   static TArtDecoderTimeStamp instance;
   return &instance;
}

int TArtDecoderTimeStamp::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
  unsigned long long int *evtdata = (unsigned long long int*) buf;
  unsigned int evtsize = size/sizeof(unsigned long long int);
  unsigned int ch, tval;

   for (int i=0; i<evtsize; i++) {
     ch = (evtdata[i] & 0xff00000000000000) >> 56;
     tval = evtdata[i] & 0x000000007fffffff;  // lower 31 bit only
     // If time difference is more than 42 s, result will be wrong.
     config->GetRawDataRef(modules[0][ch]) = tval;
   }
   return 0;
}
