/*
 * @file TArtDecoderA3100.cc
 * @date  Created : 2008/11/26 18:59:56 JST<BR>
 *  Last Modified : 2008/11/27 00:19:14 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderA3100.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"
#include <stdio.h>
TArtDecoderA3100::TArtDecoderA3100()
   : TArtDecoder(kID) {
}

TArtDecoderA3100::~TArtDecoderA3100()
{
}

TArtDecoder* TArtDecoderA3100::Instance()
{
   static TArtDecoderA3100 instance;
   return &instance;
}

int TArtDecoderA3100::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, igeo, ich;

   igeo = 0;
 //   igeo = (evtdata[0]&0x10000000) >> 28;
   for (i=0; i<evtsize; i++) {
     if((evtdata[i]&0x60000000) == 0x60000000){
        igeo = 1;
        continue;
     }
     ich = (evtdata[i]&0x0003c000) >> 14;
     if (modules[igeo][ich]) {
       //printf("a3100 modules igeo=%d, ich=%d\n", igeo,ich);
      config->GetRawDataRef(modules[igeo][ich]) = evtdata[i]&0x1fff;
      //      printf("A3100: igeo=%d / ich=%d / data=%d\n",igeo, ich, evtdata[i]&0x1fff);
     }
     //printf("A3100: ich=%d / data=%d\n", ich, evtdata[i]&0x1fff);
   }
   return 0;
}
