/* getevent.c
   Jun 22,2004  H.Baba

   Using Shared Memory and Semaphore
   with progrress bar
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include <unistd.h>

#include "bbcpri.h"

#define BARSIZE 50

#define SHMKEY  17001
#define SEMKEY  18001


struct stat filestat;
double filesize;
int blocksize,cstep,cnt,step,i;
char com;
unsigned short buf[8192];
FILE *datafile;
static int ninit = 0;
int modeflag; /* 0 = ONLINE , 1 = OFFLINE */
int shmid,semid;
int sb = 0;
unsigned int blocknum,nblocknum;
char *shmp;
#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
#else
union semun {
  int val;                        /* value for SETVAL */
  struct semid_ds *buf;           /* buffer for IPC_STAT & IPC_SET */
  unsigned short *array;          /* array for GETALL & SETALL */
  struct seminfo *__buf;          /* buffer for IPC_INFO */
};
#endif
union semun semunion;
struct sembuf semb;

/* Semaphore Interface */
void semaphore_p(void){
  semb.sem_op = -1;
  semop(semid,&semb,1);
}
void semaphore_v(void){
  semb.sem_op = 1;
  semop(semid,&semb,1);

}

/* for ONLINE */
void init_getdata__(){
  if(ninit == 0){
    blocknum = 0;
    nblocknum = 0;
    modeflag = 0;
    com = 1;
    bzero((char *)&buf,sizeof(buf));
    /* Shared Memory */
    if((shmid = shmget(SHMKEY,0x4004,IPC_CREAT|0777)) == -1){
      perror("Can't create shared memory.\n");
      exit(1);
    }
    shmp = shmat(shmid,0,0);
    
    /* Semaphore */
    if((semid = semget(SEMKEY,1,IPC_CREAT|0666)) == -1){
      perror("Can't create semaphore.\n");
      shmdt(shmp);
      shmctl(shmid,IPC_RMID,0);
      exit(1);
    }
    semunion.val = 1;

    /*
      if(semctl(semid,0,SETVAL,semunion) == -1){
      perror("Can't control semaphore.\n");
      shmdt(shmp);
      shmctl(shmid,IPC_RMID,0);
      semctl(semid,0,IPC_RMID,semunion);
      exit(1);
      }
    */
    semb.sem_num = 0;
    semb.sem_flg = SEM_UNDO;


    //bzero(shmp,0x4000);
    ninit = 1;
  }
}

void close_getdata(void){
}


/* for OFFLINE */
void open_rawdat__(char name[132],int *fnamelen,int *flag){
  char filename[132];

  bzero((char *)&buf,16384);
  bzero(filename,132);

  modeflag = 1;
  *flag = 0;
  strncpy(filename,name,*fnamelen);

  if((datafile = fopen(filename,"r")) == NULL){
    *flag = 1;
  }else{
    stat(filename,&filestat);
    filesize = (double)filestat.st_size/(1024.*1024.);
    blocksize = filestat.st_size/(16*1024);
    printf("\n");
    printf("%s  Size : %5.1f MB   Block : %d\n",
	   filename,filesize,blocksize);
    step = blocksize/BARSIZE;
    cstep = 1;
    cnt = 0;
  }
}

void close_rawdat__(void){
  fclose(datafile);
}

void statbar(void){
  if(cnt == 3){
    printf("|");
    right_cur(BARSIZE+1);
    printf("|");
    right_cur(1);
    printf("%6d/%6d",cnt,blocksize);
    fflush(stdout);
  }
  if(cnt >= step*cstep && cnt > 3){
    printf("\r");
    //right_cur(cstep);
    for(i=0;i<=cstep;i++){
      printf("=");
    }
    printf("\r");
    printf("|");
    right_cur(BARSIZE+1);
    printf("|");
    right_cur(1);
    printf("%6d/%6d",cnt,blocksize);
    cstep++;
    fflush(stdout);
  }else if(cstep != 0 && cnt%2 == 0){
    printf("\r");
    right_cur(cstep);
    
    switch(sb){
    case 0:
      printf("|");
      sb++;
      break;
    case 1:
      printf("/");
      sb++;
      break;
    case 2:
      printf("-");
      sb++;
      break;
    case 3:
      printf("\\");
      sb=0;
      break;
    }
    right_cur(BARSIZE+1-cstep);
    right_cur(15);
    fflush(stdout);
  }
}

void clstatbar(void){
  printf("\r");

  for(i=0;i<=BARSIZE+1;i++){
    printf("=");
  }
  printf("\r");
  printf("|");
  right_cur(BARSIZE+1);
  printf("|");
  right_cur(1);
  printf("%6d/%6d",blocksize,blocksize);

  fflush(stdout);
}

int get_buf(void){
  int dataflag,size;

  if(modeflag == 0){
    semaphore_p();
    memcpy((char *)&nblocknum,shmp+0x4000,4);
    if(nblocknum == blocknum){
      dataflag = 1;
    }else if(nblocknum == 0xffffffff){
      dataflag = 2;
    }else{
      blocknum = nblocknum;
      dataflag = 0;
    }
  }else{
    size = fread(buf,2,8192,datafile);
    cnt++;
    if(size == 8192){
      dataflag = 0;
    }else{
      dataflag = 3;
    }
  }

  return dataflag;
}

void get_block__(short ret[8192],int *flag){
  if(modeflag == 0){
    usleep(1);
  }
  *flag = get_buf(); 
  if(*flag == 0){
    if(modeflag == 0){
      memcpy(ret,shmp,0x4000);
    }else{
      memcpy(ret,buf,0x4000);
      statbar();
    }
  }
  if(*flag != 0 && modeflag != 0){
    clstatbar();
  }

  if(modeflag == 0){
    semaphore_v();
  }
}
