#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include        <string.h>
#ifdef _OSF_SOURCE
#include        <signal.h>
#endif

extern char *readline();
extern void add_history();

static char histbuf[32*1024];
static char *histp = histbuf;

int *naritimer_(float *param,int *nariflag)
{
	static start_flag = 1;
	static time_t t_start,t_now;
	
	
	if(start_flag != 0)	{
		t_start = time(NULL);
		start_flag = 0;
		*nariflag = 0;
		return(NULL);
	}
	
	t_now = time(NULL);
	if((*param) <= difftime(t_now,t_start))	{
		start_flag = 1;
		*nariflag = 1;
		return(NULL);
	}
	else	{
		*nariflag = 0;
		return(NULL);
	}
}

/*
 CLrdln: Interface to GNU readline package
 Author: A.Shirahashi
 Date: 26-Apr-93

 History: 29-Sep-1994: READLINE_INCLUDE
                       fix ^D handling
*/

void
clrdln_(pro, buf, len, lpro, lbuf)
  char *pro;
  char *buf;
  int *len;
  int lpro;
  int lbuf;
{
	char *p, *line;
	int i;

	p = (char *)malloc(lpro+1);
	if ( NULL == p ) {
	quit:
		memset(buf,' ',lbuf);
		*len = -1;		/* return negative value on EOF */
		return;
	}
	strncpy(p,pro,lpro);
	*(p+lpro) = '\0';
	line = readline(p);
	free(p);

	if( NULL == line ) {
		goto quit;
	}

	add_history(line);
	*len = strlen(line);
	if ( *len + 1 < sizeof(histbuf) - (histp - histbuf) ) {
		strcpy(histp, line);
		histp += *len + 1;
	} else {
		int offset = (histp - histbuf) / 2;
		offset += strlen(histbuf+offset) + 1;
		for (i = 0; i < sizeof(histbuf); i++) {
			if ( &histbuf[i+offset] < histp ) {
				histbuf[i] = histbuf[i+offset];
			} else {
				histbuf[i] = '\0';
			}
		}
		histp -= offset;
		if ( *len + 1 < sizeof(histbuf) - (histp - histbuf) ) {
			strcpy(histp, line);
			histp += *len + 1;
		}
	}

	for(i = 0; i < lbuf && i < *len; i++) {
		buf[i] = line[i];
	}

	while ( i < lbuf ) {
		buf[i] = ' ';
		i++;
	}

	free(line);
}
