// File for making the tree of PID data of BigRIPS/ZDS
// Update: 2010/10/25
// Author: Togano

#ifndef PIDDATA_H
#define PIDDATA_H

#include <vector>
#include <TObject.h>

using namespace std;

class TPidData : public TObject {
 private:
  vector<UShort_t> TOFID;
  vector<Double_t> TOF;

  vector<UShort_t> AoQID;
  vector<Double_t> Brho;
  vector<Double_t> Beta;
  vector<Double_t> Z;
  vector<Double_t> AoQ;
  
 public:
  TPidData();
  ~TPidData();
  
  void Clear();
  void Clear(const Option_t*) {};
  void Dump() const;

  // Set Functions
  void SetTOFID(UShort_t Num){TOFID.push_back(Num);}
  void SetTOF(Double_t val){TOF.push_back(val);}

  void SetAoQID(UShort_t Num){AoQID.push_back(Num);}
  void SetBrho(Double_t val){Brho.push_back(val);}
  void SetBeta(Double_t val){Beta.push_back(val);}
  void SetZ(Double_t val){Z.push_back(val);}
  void SetAoQ(Double_t val){AoQ.push_back(val);}
  // Get Functions

  Double_t GetTOF(Int_t i){return TOF.at(i);}
  Double_t GetBrho(Int_t i){return Brho.at(i);}
  Double_t GetBeta(Int_t i){return Beta.at(i);}
  Double_t GetZ(Int_t i){return Z.at(i);}
  Double_t GetAoQ(Int_t i){return AoQ.at(i);}

  ClassDef(TPidData,2)

};

#endif
