// File for Make the tree file of BigRIPS
// Test version
// Update: 2010/10/19
// Author: Togano

#ifndef FOCALPLANEDATA_H
#define FOCALPLANEDATA_H

#include <vector>
#include <TObject.h>

using namespace std;

class TFocalPlaneData : public TObject {
 private:
  vector<UShort_t> PL_DetNum;
  vector<Double_t> PL_Tcal;// averaged

  vector<UShort_t> IC_DetNum;
  vector<Double_t> IC_Ecal;
 
  vector<UShort_t> FP_DetNum; //
  vector<Double_t> FP_X;
  vector<Double_t> FP_Y;
  vector<Double_t> FP_Xdash; // angle
  vector<Double_t> FP_Ydash; // angle
  vector<Double_t> FP_PPACT;

  vector<UShort_t> TotalE_DetNum;
  vector<Double_t> TotalE_Ecal;
  vector<Double_t> TotalE_Tcal;

 public:
  TFocalPlaneData();
  virtual ~TFocalPlaneData();

  void Clear();
  void Clear(const Option_t*) {};
  void Dump() const;

  // Set Functions
  void SetPL_DetNum(UShort_t DetNum){PL_DetNum.push_back(DetNum);};
  void SetPL_Tcal(Double_t Time){PL_Tcal.push_back(Time);};

  void SetIC_DetNum(UShort_t DetNum){IC_DetNum.push_back(DetNum);};
  void SetIC_Ecal(Double_t Energy){IC_Ecal.push_back(Energy);};

  void SetFP_DetNum(UShort_t DetNum){FP_DetNum.push_back(DetNum);};
  void SetFP_X(Double_t X){FP_X.push_back(X);};
  void SetFP_Y(Double_t Y){FP_Y.push_back(Y);};
  void SetFP_Xdash(Double_t Ang){FP_Xdash.push_back(Ang);};
  void SetFP_Ydash(Double_t Ang){FP_Ydash.push_back(Ang);};
  void SetFP_PPACT(Double_t Time){FP_PPACT.push_back(Time);};

  void SetTotalE_DetNum(UShort_t DetNum){TotalE_DetNum.push_back(DetNum);};
  void SetTotalE_Ecal(Double_t Energy){TotalE_Ecal.push_back(Energy);};
  void SetTotalE_Tcal(Double_t Time){TotalE_Tcal.push_back(Time);};

  //==================================================================
  // GET functions
  
  UShort_t GetPL_Mult(){return PL_DetNum.size();}
  Double_t GetPL_Tcal(Int_t i){return PL_Tcal.at(i);}

  UShort_t GetIC_Mult(){return IC_DetNum.size();}
  Double_t GetIC_Ecal(Int_t i){return IC_Ecal.at(i);}

  UShort_t GetFP_Mult(){return FP_DetNum.size();}
  Double_t GetFP_X(Int_t i){return FP_X.at(i);}
  Double_t GetFP_Y(Int_t i){return FP_Y.at(i);}
  Double_t GetFP_Xdash(Int_t i){return FP_Xdash.at(i);}
  Double_t GetFP_Ydash(Int_t i){return FP_Ydash.at(i);}
  Double_t GetFP_PPACT(Int_t i){return FP_PPACT.at(i);}

  UShort_t GetTotalE_DetNum(){return TotalE_DetNum.size();}
  Double_t GetTotalE_Ecal(Int_t i){return TotalE_Ecal.at(i);}
  Double_t GetTotalE_Tcal(Int_t i){return TotalE_Ecal.at(i);}

  ClassDef(TFocalPlaneData,2)

};

#endif

