//File for making the tree of DALI data
//UPDATE: 2010/10/25
//Author: Togano

#ifndef DALIDATA_H
#define DALIDATA_H

#include <vector>
#include <TObject.h>

using namespace std;

class TDaliData : public TObject {
 private:
  vector<UShort_t> DetID;
  vector<Double_t> Ecal;
  vector<Double_t> Tcal;
  
  
 public:
  TDaliData();
  ~TDaliData();
  
  void Clear();
  void Clear (const Option_t*){};
  void Dump() const;

  //set functions
  void SetDetID(UShort_t ID){DetID.push_back(ID);}
  void SetEcal(Double_t Energy){Ecal.push_back(Energy);}
  void SetTcal(Double_t Time){Tcal.push_back(Time);}

  //Get Functions
  UShort_t GetDetID(Int_t i){return DetID.at(i);}
  UShort_t GetMult(){return DetID.size();}
  Double_t GetEcal(Int_t i){return Ecal.at(i);}
  Double_t GetTcal(Int_t i){return Tcal.at(i);}

  ClassDef(TDaliData,2)
  
};
    
#endif

