/*
 * @file TArtRawDataRef.h
 * @date  Created : 2008/10/30 00:44:21 JST<BR>
 *  Last Modified : 2008/10/30 23:59:16 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#ifndef TARTRAWDATAREF_H
#define TARTRAWDATAREF_H
#include "TArtCore.h"
class TArtRawDataRef  {
private:
   int fCatID;
   int fDetID;
   int fTypeID;
   int *fRawDataRef;
   int *fNHitDataRef;
   int *fHitDetRef;
   int *fNHitDetRef;
   operator int();
public:
   static const int kINVALID = -100000000;
   TArtRawDataRef();
   TArtRawDataRef(const int& catid, const int& detid, const int& type,
                  int* rawdata, int* nhitdata, 
                  int* hitdet, int* nhitdet);
   ~TArtRawDataRef(); 
   int GetVal() { return *fRawDataRef; }
   TArtRawDataRef(const TArtRawDataRef&rhs) {;}
   TArtRawDataRef& operator=(const TArtRawDataRef&rhs){;}
   inline int& operator=(const int &val){
      *fRawDataRef = val;
      if (*fNHitDataRef == 0) {
         fHitDetRef[*fNHitDetRef] = fDetID;
         (*fNHitDetRef)++;
      }
      (*fNHitDataRef)++;
   }
};



#endif // end of #ifdef TARTRAWDATAREF_H
