/*
 * @file TArtRawDataAllocator.cc
 * @date  Created : 2008/10/29 23:24:02 JST<BR>
 *  Last Modified : 2008/10/31 17:16:53 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtRawDataAllocator.h"
#include "TArtCore.h"
#include "TArtRawDataRef.h"
TArtRawDataAllocator::TArtRawDataAllocator()
   : fRawData(anarawdata_.rawdata),
     fRawHeadPos(anarawdata_.rawheadpos),
     fNHitDet(anarawdata_.nhitdet),
     fHitDet(anarawdata_.hitdet),
     fNHitData(anarawdata_.nhitdata),
     fHitHeadPos(anarawdata_.hitheadpos),
     fNDet(anarawdata_.ndet),
     fNData(anarawdata_.ndata),
     fNextRawHeadPos(0),
     fNextHitHeadPos(0),
     fRawDataRefListNextIdx(0)
{
}
TArtRawDataAllocator::~TArtRawDataAllocator()
{
   TArtCore::Info("TArtRawDataAllocator","~TArtRawDataAllocator");
   fRawData = 0;
   fRawHeadPos = 0;
   fHitDet = 0;
   fNHitDet = 0;
   fNHitData = 0;
   fNDet = 0;
   fHitHeadPos = 0;
   fNData = 0;
}

TArtRawDataAllocator* TArtRawDataAllocator::Instance()
{
   static TArtRawDataAllocator instance;
   return &instance;
}


void TArtRawDataAllocator::Initialize()
{
   fNextRawHeadPos = 0;
   fNextHitHeadPos = 0;
   fRawDataRefListNextIdx = 0;
   fRawDataRefListIdx.Clear();
}

void TArtRawDataAllocator::Register(const int& catid,
                                    const int& detid,
                                    const int& type,
                                    TArtRawDataRef **ref)
{
  if (catid > MAXCAT) { 
    printf("catid %d exceeds MAXCAT (%d)\n",catid,MAXCAT);
    return;
  }
   int catid_f = catid - 1;
   int detid_f = detid - 1;
   fNDet[catid_f] = std::max(fNDet[catid_f],detid_f+1);
   fNData[catid_f] = std::max(fNData[catid_f],type+1);
   fNCatID = std::max(fNCatID,catid_f+1);
   fRawDataRefListNextIdx++;
   if (fRawDataRefListIdx[catid_f][detid_f][type]) {
     TArtCore::Info("TArtRawDataAllocator","catid=%d, detid=%d is already exists",catid+1,detid);
     exit(0);
     return ;
   }
   fRawDataRefListIdx[catid_f][detid_f][type] = fRawDataRefListNextIdx;
   fRawDataRefList[fRawDataRefListNextIdx] = ref;
}

int TArtRawDataAllocator::Allocate()
{
   for (int catid=0; catid<fNCatID; catid++) {
      TArtMap<TArtMap<int> >& refListIdx = fRawDataRefListIdx[catid];
      if (fNextRawHeadPos > NWRAWDATA) {
         TArtCore::Info("TArtRawData","Allocate : boundary exception");
         return -1;
      }
      if (!fNDet[catid] || !fNData[catid]) continue;
      int &ndet  = fNDet[catid];
      int &ndata = fNData[catid];
      TArtCore::Info("TArtRawDataAllocator",
                     "catid = %d, ndet = %d, ndata = %d",catid+1,ndet,ndata);
      fRawHeadPos[catid] = fNextRawHeadPos + 1;
      fHitHeadPos[catid] = fNextHitHeadPos + 1;
      int *pRawData = fRawData + fNextRawHeadPos;
      int *pNHitData = fNHitData + fNextHitHeadPos;
      int *pHitDet = fHitDet + fNextHitHeadPos;
      for (int detid=0; detid<ndet; detid++) {
         if (!refListIdx[detid].GetMap().size()) continue;
         for (int idata = 0; idata < ndata; idata++) {
	   if (refListIdx[detid][idata]==0) {
	     TArtCore::Info("TArtRawDataAllocator",
			    "Not enough mapping at detid = %d, idata=%d\n",detid,idata);
	     break;
	   }
            *fRawDataRefList[refListIdx[detid][idata]] = 
	      new TArtRawDataRef(catid+1,detid+1,idata+1,
				 pRawData+detid*ndata+idata,
				 pNHitData+detid,
				 pHitDet,
                                 &fNHitDet[catid]);
         }
      }
      fNextRawHeadPos += ndet * ndata;
      fNextHitHeadPos += ndet;
   }
   TArtCore::Info("TArtRawDataAllocator","Allocated");
}
