/* $Id:$ */
/**
 * @file   TArtRIDF.cc
 * @date   Created : Mar 30, 2008 03:30:20 JST
 *   Last Modified : Sep 26, 2008 13:53:49 JST
 * @author Shinsuke OTA <ota@ribf.riken.jp>
 *  
 *  
 *    Copyright (C)2008
 */
#include "TArtRIDF.h"
#include <string.h>
#include <stdio.h>
TArtDataFormat* TArtRIDF::fgInstance = 0;
TArtRIDF::TArtRIDF()
{
}
TArtRIDF::~TArtRIDF()
{
}

TArtDataFormat* TArtRIDF::Instance()
{
  if (!fgInstance) {
    fgInstance = new TArtRIDF;
  }
  return fgInstance;
}

ArtBlockStat_t TArtRIDF::GetNextBlock(TArtDataSource* source)
{
   ArtRidfHeader_t header;
   int len;
   fPointer = 0;
   len = source->Read((char*)&header.BYTE,sizeof(header));
   //header.BIT.Print();
   if (!len) return kEOF;
   if (header.BIT.fLayer!=0 ||
       header.BIT.fSize <= 0 ||
       (header.BIT.fClassID != 0 &&
        header.BIT.fClassID != 1 &&
        header.BIT.fClassID != 2)) {
      return kERRORBLOCK;
   }
   //   printf("<TArtRIDF::GetNextBlock> fSize = %d\n",header.BIT.fSize);
   fBlockLen = header.BIT.fSize - sizeof(header)/sizeof(short);
   //   fBlockLen = header.BIT.fSize * sizeof(short) - sizeof(header);
   //   printf("<TArtRIDF::GetNextBlock> fBlockLen = %d\n",fBlockLen);
   len = source->Read((char*)fBlock,fBlockLen*sizeof(short));
   if (!len) return kEOF;
   if (len != fBlockLen*sizeof(short)) return kERRORBLOCK;
   return kNORMALBLOCK;
}
#include <stdlib.h>
#include <iostream>
using namespace std;
ArtEventStat_t TArtRIDF::GetNextEvent(unsigned short* buf,
                                            unsigned short* runbuf, 
                                            unsigned short*rnum,
                                            int &nw)
{
  //  printf("<TArtRIDF::GetNextEvent> fPointer = %d, fBlockLen = %d\n",
  //	 fPointer, fBlockLen);
  if (fPointer >= fBlockLen) return kEOB;
//  cout << "<TArtRIDF::GetNextEvent> fPointer="<< fPointer 
//       << ", fBlockLen=" << fBlockLen << endl;
   ArtRidfHeader_t header;
   header.BYTE = ((unsigned long long int*)(fBlock+fPointer))[0];
//   printf("<TArtRIDF::GetNextEvent>\n");
//   header.BIT.Print();
//   if (header.BIT.fSize == 0) exit(0);
   if (header.BIT.fSize == 0) {
      printf("<TArtRIDF::GetNextEvent> invalid header\n");
      header.BIT.Print();
      return kERROREVENT;
   }
   if (fPointer+header.BIT.fSize > fBlockLen) 
      return kERROREVENT;
   if (header.BIT.fClassID < 3) {
      fPointer += header.BIT.fSize;
      return kERROREVENT;
   }
   if (header.BIT.fClassID == 3) {
      // event data
      nw = header.BIT.fSize-6;
      memcpy(buf,fBlock+fPointer+6,nw*sizeof(short));
      fPointer += header.BIT.fSize; // reject header and event id
      return kNORMALEVENT;
   }else if (header.BIT.fClassID == 6) {
     // event data
     cout << "class id = 6" << endl;
     nw = header.BIT.fSize-10;
      memcpy(buf,fBlock+fPointer+10,nw*sizeof(short));
      fPointer += header.BIT.fSize; // reject header and event id
      return kNORMALEVENT;
   } else {
      nw = header.BIT.fSize;
      memcpy(buf,fBlock+fPointer,nw*sizeof(short));
      fPointer += header.BIT.fSize;
      return kNORMALEVENT;
   }
}
#include <stdlib.h>
void TArtRIDF::FindSegment(unsigned short *evtdata,
                           int *evtsize,
                           int *segid,
                           int *addr,
                           int *nw,
                           int *maxsegid)
{
   int iw = 0;
   int iseg;
   for (iseg=0;iseg<*maxsegid;iseg++) {
      addr[iseg] = -1;
      nw[iseg]   = 0;
   }
   ArtRidfHeader_t header;
   iseg = 0;
   while(iw < *evtsize && iseg < *maxsegid) {
      header.BYTE = ((unsigned long long int*)(evtdata+iw))[0];
      if (header.BIT.fSize == 0) {
         cout << "<TArtRIDF::FindSegment> header.BIT.fSize = " 
              << header.BIT.fSize << endl;
         cout << "<TArtRIDF::FindSegment> evtsize = " << *evtsize
              << ", iw = " << iw << endl;
         header.BIT.Print();
         return;
      }
      if (header.BIT.fClassID == 4) {
         segid[iseg] = *((int*)(evtdata+iw+4));
	 printf("segid = %d\n", segid[iseg]);
         // +4 : exclude header
         // +2 : exclude iseg
         // +1 : for conversion to fortran-like array
         // totally +7
         addr[iseg] = iw + 7;
         // -4 : exclude header
         // -2 : exclude iseg
         // totally -6
         nw[iseg]   = header.BIT.fSize - 6;
         iseg++;
      }
      iw += header.BIT.fSize;
   }
}
