/*
 * @file TArtParserXMLStatus.cc
 * @date  Created : 2008/10/30 19:59:23 JST<BR>
 *  Last Modified : 2010/12/15 19:47:18 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtParserXMLStatus.h"
#include <string.h>
#include <stdio.h>

static char noxml[] = "no xml status\0";


TArtParserXMLStatus::TArtParserXMLStatus()
{
  xp = NULL; xdaqinfo = NULL; xrunstatus = NULL;
}
TArtParserXMLStatus::~TArtParserXMLStatus()
{
  bbxml_free(xp);
  xp = NULL;
  xrunstatus = NULL;
}

TArtParserXMLStatus* TArtParserXMLStatus::Instance()
{
  static TArtParserXMLStatus instance;
  return &instance;
}

void TArtParserXMLStatus::Parse(char *buff, int len)
{
  if(xp){
    bbxml_free(xp);
    xp = NULL;
    xrunstatus = NULL;
  }
  xp = bbxml_parsebuff(buff, len);
  if(xp){
    xdaqinfo = bbxml_node(xp, "babild");
    }
  if(xdaqinfo){
    xrunstatus = bbxml_node(xdaqinfo, "runstatus");
  }
}

char *TArtParserXMLStatus::RunStatus(char *cat, char *name, char *tag){
  BBXMLEL *f = NULL, *r = NULL, *n = NULL;
  if(!xrunstatus) return noxml;
  f = bbxml_node(xrunstatus, cat);
  if(!f) return noxml;
  n = bbxml_node(f, "name");
  if(!n) return noxml;
  while(strcmp(n->text, name)){
    f = bbxml_next(f, cat);
    if(!f) break;
    n = bbxml_node(f, "name");
    if(!n) break;
  }
  if(!f) return noxml;
  r = bbxml_node(f, tag);
  if(!r) return noxml;
  return r->text;
}

void TArtParserXMLStatus::printAllRunStatus(void){
  printf("cpp print_allrunstatus\n");
  bbxml_printall(xrunstatus);
}  

/// for anapaw compatible function
void xget_runstatus__(char cat[132], char name[132], char tag[132], char val[132]){
  char t[132];
  int idx;

  memcpy(strchr(cat, ' '), "\0", 1);
  memcpy(strchr(name, ' '), "\0", 1);
  memcpy(strchr(tag, ' '), "\0", 1);
  
  memset(val, ' ', 132);
  //TArtParserXMLStatus::Instance()->RunStatus(cat, name, tag);
  strncpy(t, TArtParserXMLStatus::Instance()->RunStatus(cat, name, tag), 132);
  memcpy(val, t, strlen(t));
}

void print_allrunstatus__(){
  TArtParserXMLStatus::Instance()->printAllRunStatus();
}
