/*
 * @file TArtParserRIDF.h
 * @date  Created : 2008/10/17 18:27:33 JST<BR>
 *  Last Modified : 2010/12/15 18:26:43 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#ifndef TARTPARSERRIDF_H
#define TARTPARSERRIDF_H
#include "TArtParser.h"
#include "TArtCore.h"
#include "TArtEventStore.h"
class TArtParserRIDF  : public TArtParser {
public:
   typedef union {
      unsigned long long int BYTE;
      struct {
         unsigned long int fSize:22;
         unsigned long int fClassID:6;
         unsigned long int fLayer:2;
         unsigned long int fReserved:2;
         unsigned long int fAddress:32;
         void Print() {
            TArtCore::Info("TArtParserRIDF","Header Information");
            TArtCore::Info("TArtParserRIDF","Size  = %d",fSize);
            TArtCore::Info("TArtParserRIDF","Class = %d",fClassID);
            TArtCore::Info("TArtParserRIDF","Layer = %d",fLayer);
            TArtCore::Info("TArtParserRIDF","Addr  = %d",fAddress);
         }
      } BIT;
   } ArtHeader_t;

   typedef union {
      unsigned int BYTE;
      struct {
         unsigned int fModule:8;
         unsigned int fDetector:6;
         unsigned int fFP:6;
         unsigned int fDevice:6;
         unsigned int fVersion:6;
      } BIT;
   } ArtSegIDRIDF_t;
private:
   ArtHeader_t fHeader;
public:
   virtual void GetNextBlock(TArtDataSource *source) ;
   virtual void GetNextEvent(TArtMapConfig *mapConfig) ;
   virtual int CopyPrevEvent(char *dest);
   virtual int CopyDumpStat(char *dest);
   static TArtParser* Instance();
   ~TArtParserRIDF();

private:
   TArtParserRIDF();


};
#endif // end of #ifdef TARTPARSERRIDF_H
