/*
 * @file TArtParserRIDF.cc
 * @date  Created : 2008/10/20 13:20:43 JST<BR>
 *  Last Modified : 2010/12/15 19:29:09 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtParserRIDF.h"
#include "TArtEventStatus.h"
#include "TArtCore.h"
#include "TArtDecoderFactory.h"
#include "TArtParserXMLStatus.h"
#include <iostream>
//#define DEBUG

/** RIDF comment header structure */
struct ridf_comment_runinfost{
  char runname[100];
  char runnumber[100];
  char starttime[20];
  char stoptime[20];
  char date [20];
  char rev[40];
  char header[100];
  char ender[100];
};

TArtParserRIDF::TArtParserRIDF()
{
}
TArtParserRIDF::~TArtParserRIDF()
{
}

TArtParser* TArtParserRIDF::Instance()
{
   static TArtParserRIDF parserRIDF;
   return (TArtParser*) &parserRIDF;
}

void TArtParserRIDF::GetNextBlock(TArtDataSource *source) 
{
   fOffset = 0;
   fNext   = 0;
   if (!source->IsPrepared()) {
     return ;
   }
   if (source->Read((char*)&fHeader,sizeof(fHeader)) == 0) {
      TArtEventStatus::Instance()->SetFileEnd(true);
      fHeader.BYTE = 0;
      source->Wait();
      return;
   }
   fBlockSize = fHeader.BIT.fSize*sizeof(short)-sizeof(fHeader);
   if (source->Read((char*)fBlockBuffer,fBlockSize) == 0) {
      TArtEventStatus::Instance()->SetFileEnd(true);
      fHeader.BYTE = 0;
      source->Wait();
      return;
   }
   source->Wait();
   fEOB    = false;
   TArtEventStatus::Instance()->AddBlkCnt();
}


void TArtParserRIDF::GetNextEvent(TArtMapConfig *config)
{
   fHeader.BYTE = *(unsigned long long int*)&fBlockBuffer[fNext];
   fOffset = fNext;
   fPrev = fNext;
   fNext = fOffset + fHeader.BIT.fSize*sizeof(short);
   if (fBlockSize <= fNext) fEOB = true;
#ifdef DEBUG
   fHeader.BIT.Print();
   printf("class = %d\n",fHeader.BIT.fClassID);
#endif
   switch (fHeader.BIT.fClassID) {
   case 3: // event data header w/o timestamp
      fOffset += sizeof(fHeader) + 4;
      break;
   case 6: // event data header w/ timestamp
      fOffset += sizeof(fHeader) + 12;
      break;
   case 5: // comment block
     struct ridf_comment_runinfost info;
     int idx, cid;
     idx = fOffset + sizeof(int)*3;  // skip header
     memcpy((char *)&cid, fBlockBuffer+idx, sizeof(int));
     if(cid == 1){  // Comment ID 1 = Header
       idx = fOffset + sizeof(int)*4;  // skip header
       memcpy((char *)&info, fBlockBuffer+idx, sizeof(info));
       anarunstat_.rnumber = strtol(info.runnumber, NULL, 10);
       TArtCore::Info("TArtParserRIDF","Run number = %04d", anarunstat_.rnumber);
     }
     return;
     break;
   case 21: // status block
     int len;
     char buff[8192];
     memset(buff, 0, sizeof(buff));
     len = fHeader.BIT.fSize*2 - sizeof(int)*3; // status len
     idx = fOffset + sizeof(int)*3;  // skip header
     memcpy((char *)&cid, fBlockBuffer+idx, sizeof(int));
     if(cid == 11){  // Status ID 11 = Runstatus Start
       idx = fOffset + sizeof(int)*4;  // skip header
       memcpy(buff, fBlockBuffer+idx, len);
       TArtParserXMLStatus::Instance()->Parse(buff, len);
       TArtCore::Info("TArtParserRIDF","RunStatus Read");

       // Copy to Status Buffer for Rdump
       memcpy(fStatusBuffer, fBlockBuffer+fOffset, fHeader.BIT.fSize*2);
       SetDumpStat(true);
     }
     return;
   default:
     return;
     break;
   }
   TArtEventStatus::Instance()->SetERFlag(true);
   TArtEventStatus::Instance()->AddTrigNum();
   while (fOffset < fNext) {
     fHeader = *(ArtHeader_t*)&fBlockBuffer[fOffset];
#ifdef DEBUG
     fHeader.BIT.Print();
#endif
     // Segment data ClassID = 4
     if (fHeader.BIT.fClassID == 4) {
       ArtSegIDRIDF_t segid = 
	 *(ArtSegIDRIDF_t*)(fBlockBuffer+fOffset+sizeof(fHeader));
       unsigned int size = 
	 fHeader.BIT.fSize*sizeof(short)
	 -sizeof(fHeader)-sizeof(unsigned int);
       //TArtCore::Info("TArtParserRIDF","segid = %08x",segid);         
       unsigned char *buf = fBlockBuffer+fOffset+sizeof(fHeader)+sizeof(segid);
       
       
#ifdef DEBUG
       TArtCore::Info("TArtParserRIDF","fp=%d,det=%d\n",
		      segid.BIT.fFP,segid.BIT.fDetector);
#endif
       
       
       TArtMapConfig::TArtMapModules &modules = 
	 config->GetMapModules(segid.BIT.fDevice,segid.BIT.fFP,segid.BIT.fDetector);
       if (modules.GetMap().size()) {
	 TArtDecoder *decoder = TArtDecoderFactory::Instance()->
	   GetDecoder((segid.BIT.fModule));
	 if (!decoder) {
	   TArtCore::Info("TArtParserRIDF","No such decoder ID = %d",segid.BIT.fModule);
	   
	 } else {
	   TArtDecoderFactory::Instance()->
	     GetDecoder((segid.BIT.fModule))->Decode(buf,size,modules,config);
	 }
       }
     }else if(fHeader.BIT.fClassID == 16) {
       // Time stamp data ClassID = 16
       unsigned int tval = 0x03aeba3a;
       ArtSegIDRIDF_t segid = *(ArtSegIDRIDF_t*)&tval;
       //              dev/fp /det/mod
       // special case  58/ 58/ 58/ 58

       unsigned int size = 
	 fHeader.BIT.fSize*sizeof(short)-sizeof(fHeader);
       unsigned char *buf = fBlockBuffer+fOffset+sizeof(fHeader);
       
       TArtMapConfig::TArtMapModules &modules = 
	 config->GetMapModules(segid.BIT.fDevice,segid.BIT.fFP,segid.BIT.fDetector);
       if (modules.GetMap().size()) {
	 TArtDecoder *decoder = TArtDecoderFactory::Instance()->
	   GetDecoder((segid.BIT.fModule));
	 if (!decoder) {
	   TArtCore::Info("TArtParserRIDF","No such decoder ID = %d",segid.BIT.fModule);
	 } else {
	   TArtDecoderFactory::Instance()->
	     GetDecoder((segid.BIT.fModule))->Decode(buf,size,modules,config);
	 }
       }
     }

     fOffset += fHeader.BIT.fSize*sizeof(short);
   }

}


int TArtParserRIDF::CopyPrevEvent(char *dest)
{
  int size;

  size = fNext - fPrev;
  memcpy(dest, fBlockBuffer+fPrev, size);

  return size;
}

int TArtParserRIDF::CopyDumpStat(char *dest)
{
  int size;
  ArtHeader_t hd;

  if(fDumpStat){
    SetDumpStat(false);
    memcpy((char *)&hd, fStatusBuffer, sizeof(hd));
    size = hd.BIT.fSize*2;
    memcpy(dest, fStatusBuffer, size);
  }else{
    size = 0;
  }

  return size;
}
