/*
 *    TArtParser.h
 *    Created       : 2008/09/26 13:54:03 JST
 *    Last Modified : 2010/12/15 19:34:37 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA
 */
#ifndef TARTPARSER_H
#define TARTPARSER_H
#include "TArtDataSource.h"
#include "TArtMapConfig.h"
class TArtParser {
public:
   static const int kMaxBufLen;
   static const int kMaxStatLen;
   virtual ~TArtParser();
   virtual void Parse(TArtDataSource *source,TArtMapConfig *mapConfig);
   virtual int CopyPrevEvent(char *dest) = 0;
   virtual int CopyDumpStat(char *dest) = 0;
   virtual void SetEOB(bool t){ fEOB = t; }
   virtual void SetDumpStat(bool t){ fDumpStat = t; }
   virtual bool GetDumpStat(void){ return fDumpStat; }
protected:
   virtual void GetNextBlock(TArtDataSource *source) = 0;
   virtual void GetNextEvent(TArtMapConfig *mapConfig) = 0;
   unsigned char *fBlockBuffer;
   unsigned char *fStatusBuffer;
   int fOffset;
   int fNext;
   int fPrev;
   int fBlockSize;
   bool fEOB;
   bool fEOF;
   bool fDumpStat;
protected:
   TArtParser();
   TArtParser(const TArtParser&) {;}
   TArtParser& operator=(const TArtParser&) {;}
};
#endif // end of #ifdef TARTPARSER_H
