/*
 * @file TArtParser.cc
 * @date  Created : 2008/10/19 20:09:04 JST<BR>
 *  Last Modified : 2010/12/15 17:44:56 
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtParser.h"
#include "TArtEventStatus.h"
const int TArtParser::kMaxBufLen = 0x40000;
const int TArtParser::kMaxStatLen = 16384;
TArtParser::TArtParser() 
  : fBlockBuffer(0), fOffset(0), fNext(0), fBlockSize(0), fEOB(true), fEOF(true), fStatusBuffer(0)
{
   fBlockBuffer = new unsigned char[kMaxBufLen];
   fStatusBuffer = new unsigned char[kMaxStatLen];
   TArtEventStatus::Instance()->SetERFlag(false);
}

TArtParser::~TArtParser()
{
   delete [] fBlockBuffer;
   delete [] fStatusBuffer;
}

void TArtParser::Parse(TArtDataSource* source, TArtMapConfig *config) 
{
   TArtEventStatus::Instance()->SetERFlag(false);
   if (fEOB) GetNextBlock(source);
   if (fEOB) return;
   GetNextEvent(config);
}
