/* $Id:$ */
/**
 * @file   TArtFileDataSourceGZ.cc
 * @date   Created : Mar 29, 2008 16:29:43 JST
 *   Last Modified : 2009/01/19 13:31:26 JST
 * @author RIPS Taro <rips@entrance.ripsnet>
 *  
 *  
 *    Copyright (C)2008
 */
#include <stdlib.h>
#include "TArtFileDataSourceGZ.h"
#include "TArtRDF.h"
#include "TArtRIDF.h"
#include "TArtCore.h"
#include <string.h>

/* Size */
#define RIDF_COMMENT_RUNINFO_ASC_SIZE   1024

/** RIDF comment header structure */
struct ridf_comment_runinfost{
  char runname[100];
  char runnumber[100];
  char starttime[20];
  char stoptime[20];
  char date [20];
  char rev[40];
  char header[100];
  char ender[100];
};


TArtDataSource* TArtFileDataSourceGZ::fgInstance = 0;
TArtFileDataSourceGZ::TArtFileDataSourceGZ()
: fFile(0) {
}
TArtFileDataSourceGZ::~TArtFileDataSourceGZ()
{
}

TArtDataSource* TArtFileDataSourceGZ::Instance() 
{
   if (!fgInstance) {
      fgInstance = new TArtFileDataSourceGZ;
   } 
   return fgInstance;
}
         

int TArtFileDataSourceGZ::Open(const char* sourceName) 
{
   if (!sourceName) return (fFileStatus = kNOTEXIST);
   if (stat(sourceName,&fFileStat)) return (fFileStatus = kNOTEXIST);
   if (fFile) gzclose(fFile);
   fFile = gzopen(sourceName,"rb"); 
   if (fFile == NULL) {
     printf("<TArtFileDataSourceGZ::Open> unexpected error at line %d\n",
	    __LINE__);
     int errnum;
     gzerror(fFile, &errnum);
     printf("<TArtFileDataSourceGZ::Open> error num = %d\n", errnum);
     return kNOTEXIST;
   }
   TArtCore::Info("TArtFileDataSourceGZ","File = %s",sourceName);
   TArtCore::Info("TArtFileDataSourceGZ","Size = %5.2f (MB) GZIP",
                  fFileStat.st_size/1024./1024.);
   long pos = gztell(fFile);
   unsigned int header[2];
   char buff[RIDF_COMMENT_RUNINFO_ASC_SIZE];
   struct ridf_comment_runinfost info;
   char start[20], stop[20];

   fRunNumber = 0;
   gzread(fFile, (char*)header,sizeof(int)*2);
   if (header[1]!=0) {
      // RIDF format
      fFormat = TArtRIDF::Instance();
      TArtCore::Info("TArtFileDataSourceGZ","Format = RIDF");

      gzread(fFile, (char*)header,sizeof(int)*2);
      if(((header[0]>>22)&0x3f) == 5){
	gzread(fFile, (char*)header,sizeof(int)*2);

	if(header[1] == 1){
	  gzread(fFile, (char *)&info, sizeof(info));
	  memset(start, 0, sizeof(start));
	  memset(stop, 0, sizeof(stop));
	
	  memcpy(start, info.starttime+9, sizeof(start)-9);
	  memcpy(stop, info.stoptime+8, sizeof(stop)-8);
	  
	  TArtCore::Info("TArtFileDataSourceGZ","Run name   = %s", info.runname);
	  TArtCore::Info("TArtFileDataSourceGZ","Run number = %s", info.runnumber);
	  TArtCore::Info("TArtFileDataSourceGZ","Start time = %s", start);
	  TArtCore::Info("TArtFileDataSourceGZ","Stop time  = %s", stop);
	  TArtCore::Info("TArtFileDataSourceGZ","Date       = %s", info.date);
	  TArtCore::Info("TArtFileDataSourceGZ","Header     = %s", info.header);
	  TArtCore::Info("TArtFileDataSourceGZ","Ender      = %s", info.ender);
	  
	  fRunNumber = strtol(info.runnumber, NULL, 10);
	}
      }

   } else {
      fFormat = TArtRDF::Instance();
      TArtCore::Info("TArtFileDataSourceGZ","Format = RDF");
   }
   
   gzseek(fFile,pos,0);
   return (fFileStatus = kEXIST);
}


void TArtFileDataSourceGZ::Close() 
{
   if (fFile) gzclose(fFile);
   fFile = 0;
   fFileStatus = kNOTEXIST;
}

int TArtFileDataSourceGZ::Seek(long offset, int origin) 
{
   if (!fFile) return -1;
   return gzseek(fFile,offset,origin);
}
   

int TArtFileDataSourceGZ::Read(char *buf, const int &size, const int & /* offset */)
{
   if (!fFile) return 0;
   return gzread(fFile, buf,sizeof(char)*size);
}

//ArtBlockStat_t TArtFileDataSourceGZ::GetNextBlock() {
////   printf("<TArtFileDataSourceGZ::GetNextBlock> get block with fFormat at %p\n",
////          fFormat);
////   printf("<TArtFileDataSourceGZ::GetNextBlock> with this at %p\n",this);
////   printf("<TArtFileDataSourceGZ::GetNextBlock> fFormat at %p\n",fFormat);
//   return fFormat->GetNextBlock(this);
//}
  
