/*
 *    ARTEventStore.hh
 *    Created       : Jan 19 2007 01:09:13
 *    Last Modified : 2008/10/30 22:05:58 JST
 *--------------------------------------------------------
 *    Comment : EventStore is a singleton for anaroot and anapaw
 *    
 *--------------------------------------------------------
 *    Copyright (C)2007-2008 by ota
 */
#ifndef TARTEVENTSTORE_H
#define TARTEVENTSTORE_H

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <fstream>
#include "TArtParser.h"
#include "TArtSharedMemory.h"
#include "TArtSemaphore.h"
#include "TArtDataSource.h"
#include "TArtMapConfig.h"
using namespace std;

#define MAXFILENAME 1024
#define MB 1048576 // Unit of MByte (1024*1024)
#define MAXBLOCKSIZE 131072 // maximum block size 128kByte
#define WORDSIZE 2 // Byte

// for anapaw compatible
#ifdef __cplusplus
extern "C" {
#endif
   void init_getdata__();
   void open_rawdat__(char name[132], int* fnamelen, int* flag);
   void close_rawdat__();
   void eventread_();
   void art_clear_store__();
   void art_init_store__();
   void usercalcdata__(int rawData, int kMaxCat, int kMaxDet,int kMaxData,
                       int nHitDet, int idHitDet, int nDataMin, int nData);
#ifdef __cplusplus
}
#endif


extern "C" {
  extern struct {
    int rnumber;
  } anarunstat_;
}

/** TArtEventStore
 *
 *
 */
class TArtEventStore {
public:
   ~TArtEventStore();
   static TArtEventStore *Instance();
   int Open(const char *filename = 0);
   void Clear();
   ArtEventStat_t GetNextEvent();
   void GetEvent();
   void Initialize();
   void Close();   
private:
   TArtDataSource   *fDataSource;
   TArtParser       *fParser;
   TArtMapConfig    *fMapConfig;
   bool fIsInitialied;
   char    *fMapFileName;
   static TArtEventStore *fgEventStore;
private:
   TArtEventStore();
   TArtEventStore(const TArtEventStore&) {;}
   TArtEventStore& operator=(const TArtEventStore&) {;}

};
#endif // end of #ifdef TARTEVENTSTORE_H
