/*
 *    TArtEventStore.cc
 *    Created       : Jan 19 2007 02:48:33
 *    Last Modified : 2009/01/19 13:30:56 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2007 by ota
 */
#include "TArtCore.h"
#include "TArtEventStore.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>

#include "TArtParserFactory.h"
#include "TArtMapConfig.h"
#include "TArtDataSourceFactory.h"
#include "TArtCore.h"
TArtEventStore* TArtEventStore::fgEventStore = 0;

//////////////////////////////////////////////////
//

TArtEventStore::TArtEventStore()
   : fDataSource(0), fParser(0), fIsInitialied(false)
{
   TArtCore::Info("TArtEventStore","Constructor");
   fMapConfig = TArtMapConfig::Instance();
}

TArtEventStore::~TArtEventStore()
{
}

void TArtEventStore::Clear() 
{
   fDataSource = 0;
   fIsInitialied = false;
}

void TArtEventStore::Initialize()
{
   if (fIsInitialied) return;
   fMapConfig->Initialize();
   fMapFileName = getenv("ART_MAPCONFIG");
   if (fMapFileName == NULL) {
      TArtCore::Info("TArtEventStore","Initialize : SET ART_MAPCONFIG!!!");
      exit(0);
   }
   fMapConfig->LoadConfig(fMapFileName);
}



TArtEventStore* TArtEventStore::Instance()
{
   if (!fgEventStore) fgEventStore = new TArtEventStore();
   return fgEventStore;
}


int TArtEventStore::Open(const char *filename)
{
   fDataSource = TArtDataSourceFactory::Instance()->Create(filename);
   int ret = fDataSource->Open(filename);
   if (ret) return ret;

   anarunstat_.rnumber = fDataSource->GetRunNumber();

   fParser = TArtParserFactory::Create(fDataSource);
   fParser->SetEOB(true);

   return ret;
}

void TArtEventStore::Close()
{
}

ArtEventStat_t TArtEventStore::GetNextEvent()
{
   TArtRawDataAllocator::Instance()->ClearData();
   fParser->Parse(fDataSource,fMapConfig);
}
   

void TArtEventStore::GetEvent()
{
}
///////////////////////////////////////////////////////////////////////////
// anapaw compatible function
///////////////////////////////////////////////////////////////////////////
void eventread_() {
   TArtEventStore::Instance()->GetNextEvent();
}


void init_getdata__() 
{
  char dummy[132];
  dummy[0] = 0;
   TArtEventStore* store = TArtEventStore::Instance();
   // store->Open();
   store->Open(dummy);
}

void art_clear_store__()
{
   TArtEventStore::Instance()->Initialize();
}

void art_init_store__()
{
   TArtEventStore::Instance()->Initialize();
}


/**
 *
 * @param flag [out] 0 when file is normally opened, 1 when file does not exist
 */
void open_rawdat__(char name[132], int *fnamelen, int *flag)
{
   char filename[256];
   bzero(filename,256);
   strncpy(filename,name,*fnamelen);

   TArtEventStore *store = TArtEventStore::Instance();
   *flag = store->Open(filename);
}

void close_rawdat__()
{
   TArtEventStore::Instance()->Close();
}

//void get_block__(short ret[MAXBLOCKSIZE], int *flag)
//{
//   TArtEventStore *store = TArtEventStore::Instance();
//   *flag = store->GetNextBlock();
//}
//
//void get_evt__(unsigned short *blkbuf, unsigned short *evtbuf, 
//               unsigned short *blkflg, unsigned short *runbuf,
//               unsigned short *rnum, int *nw)
//{
//   TArtEventStore *store = TArtEventStore::Instance();
//   *blkflg = store->GetNextEvent(evtbuf,runbuf,rnum,*nw);
//}
//
//void findsegment_(unsigned short* evtdata,
//<<<<<<< .mine
//                  int *evtsize,
//                  int *segid,
//                  int *addr,
//                  int *nw,
//                  int *maxsegid)
//=======
//                   int *evtsize,
//		   int *segid,
//                   int *addr,
//                   int *nw,
//                   int *maxsegid)
//>>>>>>> .r7
//{
//   TArtEventStore::Instance()->GetDataSource()->GetDataFormat()->
//      FindSegment(evtdata,evtsize,segid,addr,nw,maxsegid);
//}
