/*
 * @file TArtDecoderV1190C.cc
 * @date  Created : 2008/11/26 21:34:03 JST<BR>
 *  Last Modified : Nov 02, 2010 13:35:22 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderV1190C.h"
#define TRIGCH0 1

TArtDecoderV1190C::TArtDecoderV1190C()
   : TArtDecoder(kID) {
}
TArtDecoderV1190C::~TArtDecoderV1190C()
{
}

TArtDecoder* TArtDecoderV1190C::Instance()
{
   static TArtDecoderV1190C instance;
   return &instance;
}

int TArtDecoderV1190C::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, ih, igeo, ich, icat ,idet, idata;
   int ghf, thf, bncid, evtid, edge;
   int evtflag = 0;
   ghf = thf = 0;
   int ttrigger = 0;
   TArtRawDataRef *data[2560];
   TArtRawDataRef *mdata[2560];
   unsigned int rawt[2560];
   unsigned int rawm[2560];
   unsigned int multi[256];

   int nhit = 0;
   int mhit = 0;

   
   for (int i=0; i<evtsize; i++) {
      ih = evtdata[i]&kHeaderMask;
      //printf("%d (ih=%08lx): 0x%08lx\n",i,ih,evtdata[i]);
      //printf("igeo = %d (0x%x)\n",igeo,igeo); 
      if (ih == kGlobalHeader) {
	nhit = 0;
         ghf = 1;
         igeo = (evtdata[i]&kMaskGeometry)>>kShiftGeometry;

	 //	 printf("V1190C [Global Header] : 0x%08x\n", evtdata[i]);

	 //for (int j=0;j<256;j++){multi[j]=0;}
	 memset((char *)multi, 0, sizeof(multi));

      } else if (ih == kTDCHeader) {
	//printf("V1190C [TDC    Header] : 0x%08x\n", evtdata[i]);
         if (ghf != 1) break;
         //thf = 1;
         bncid = (evtdata[i]&kMaskBunchID)>>kShiftBunchID;
         evtid = (evtdata[i]&kMaskEventCounter)>>kShiftEventCounter;
      } else if (ih == kTDCMeasurement) {
	//printf("V1190C [TDC Measureme] : 0x%08x\n", evtdata[i]);
         //if (thf != 1) continue;
         ich = (evtdata[i]&kMaskChannel) >> kShiftChannel;
         edge = (evtdata[i]&kMaskEdgeType) >> kShiftEdgeType;

	 if (edge==1) ich+=128;
	 //write(*,*) 'igeo=',igeo,' ich=',ich, ' edge=',edge

	 //	printf("igeo=%d, ich=%d, edge=%d\n", igeo,ich,edge);

#ifdef TRIGCH0
	 // 2010/11/02 S.Takeuchi
	 //	 if (ich==0) { 
	 if (ich==127) {
	   //
	   ttrigger = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
	   continue;
	 }
#endif
	 /* Check first hit */

	 if (modules[igeo][ich+128]){
	   multi[ich]++;
	   mdata[mhit] = &config->GetRawDataRef(modules[igeo][ich+128]);
	   rawm[mhit] = multi[ich];
	   //	   if (multi[ich]>1){
	   //	     printf("ich %d, nhit %d, multi %d, rawt %d\n",ich,nhit,multi[ich],rawt[nhit]);
	   //	   }
	   mhit++;
	 }
	 
	 if (modules[igeo][ich]){
	   if(config->GetRawDataVal(modules[igeo][ich]) == 
	      TArtRawDataRef::kINVALID){
#if TRIGCH0
	     data[nhit] = &config->GetRawDataRef(modules[igeo][ich]);
	     rawt[nhit] = (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
	     nhit++;
#endif
#ifndef TRIGCH0
	       config->GetRawDataRef(modules[igeo][ich]) =
	       (evtdata[i]&kMaskMeasure) >> kShiftMeasure;
#endif
	     //printf("rawt[%d] = %d\n",nhit,rawt[nhit]);
	   } 
	 }
	 
      } else if (ih == kTDCTrailer) {
	//printf("V1190C [TDC Trailer  ] : 0x%08x\n", evtdata[i]);
	 //thf = 0;
      } else if (ih == kTDCError) {
	//printf("V1190C [TDC Error    ] : 0x%08x\n", evtdata[i]);
      } else if (ih == kGlobalTrailer) {
#ifdef TRIGCH0
	for (int j = 0; j!=nhit;j++) {
	  //	  *data[j] = -(ttrigger  - rawt[j] - (ttrigger&0xfffff000));
	  //*data[j] = rawt[j];
	  if (data[j]->GetVal() == TArtRawDataRef::kINVALID) {
	    //	    *data[j] = -(ttrigger  - rawt[j]) + 20000;
	    *data[j] = -(ttrigger  - rawt[j]);
	    //printf("rawt[%d] = %d, ttrigger=%d\n",j,rawt[j],ttrigger);
	  }
	}
#endif
	//	printf("V1190C [Global Traile] : 0x%08x\n", evtdata[i]);
         ghf = 0;
	 for (int j=0;j!=mhit;j++){
	   *mdata[j] = rawm[j];
	 }
      }
   }
   return 0;
}
