/*
 * @file TArtDecoderLUPO.cc
 * @date  Created : 2008/11/26 18:59:56 JST<BR>
 *  Last Modified : 2008/11/27 00:19:14 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2009 by Kenta Yoshinaga
 */
#include "TArtDecoderLUPO.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"
#include <stdio.h>
TArtDecoderLUPO::TArtDecoderLUPO()
   : TArtDecoder(kID) {
}

TArtDecoderLUPO::~TArtDecoderLUPO()
{
}

TArtDecoder* TArtDecoderLUPO::Instance()
{
   static TArtDecoderLUPO instance;
   return &instance;
}

int TArtDecoderLUPO::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, ih, igeo, ich, icat ,idet, idata;
   int evtflag = 0;

   igeo = 0;
   ich  = 0;
   for (int i=0; i<evtsize; i++) {
         evtflag = 1;
	 if (modules[igeo][ich]) {
	   config->GetRawDataRef(modules[igeo][ich]) = 
          evtdata[i]&0xffffffff;
     }
   }
   return 0;
}
