/*
 * @file TArtDecoderGANIL.cc
 * @date  Created : 2008/10/29 24:08:53 JST<BR>
 *  Last Modified : 2008/10/30 23:59:31 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDecoderGANIL.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"

TArtDecoderGANIL::TArtDecoderGANIL()
   : TArtDecoder(kID) {
}

TArtDecoderGANIL::~TArtDecoderGANIL()
{
}

TArtDecoder* TArtDecoderGANIL::Instance()
{
   static TArtDecoderGANIL instance;
   return &instance;
}

int TArtDecoderGANIL::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned short *evtdata = (unsigned short*) buf;
   unsigned int evtsize = size/sizeof(unsigned short);
   int id, i;

   for (int i=0; i<evtsize; i+=2) {
     id = evtdata[i];
     config->GetRawDataRef(modules[0][id]) = evtdata[i+1];
   }
   return 0;
}
