/*
 * @file TArtDecoderAP.cc
 * @date  Created : 2008/11/26 18:59:56 JST<BR>
 *  Last Modified : 2008/11/27 00:19:14 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2009 by Kenta Yoshinaga
 */
#include "TArtDecoderAP.h"
#include "TArtDecoderFactory.h"
#include "TArtCore.h"
#include <stdio.h>
TArtDecoderAP::TArtDecoderAP()
   : TArtDecoder(kID) {
}

TArtDecoderAP::~TArtDecoderAP()
{
}

TArtDecoder* TArtDecoderAP::Instance()
{
   static TArtDecoderAP instance;
   return &instance;
}

int TArtDecoderAP::Decode(unsigned char* &buf, const unsigned int& size,
                               TArtMapConfig::TArtMapModules &modules,
                               TArtMapConfig *config)
{
   unsigned int *evtdata = (unsigned int*) buf;
   unsigned int evtsize = size/sizeof(unsigned int);
   int i, ih, igeo, ich, icat ,idet, idata;
   int evtflag = 0;

   for (int i=0; i<evtsize; i++) {
         igeo = (evtdata[i]&0x000000f0)>>4;
//         printf("geo = %d \n",igeo);
         evtflag = 1;
         ich = (evtdata[i]&0x0000000f);
	 if (modules[igeo][ich]) {
	   config->GetRawDataRef(modules[igeo][ich]) = 
          (evtdata[i]&0x1fff0000)>>16;
     }
   }
   return 0;
}
