/*
 *    TArtDecoder.h
 *    Created       :  9 26 2008 02:11:03
 *    Last Modified : 2008/10/30 21:51:57 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA
 */
#ifndef TARTDECODER_H
#define TARTDECODER_H
#include "TArtMapConfig.h"
class TArtDecoder  {
protected:
   int fID;
   TArtDecoder(int id =0) : fID(id) {;}
   TArtDecoder(const TArtDecoder&) {;}
   TArtDecoder& operator=(const TArtDecoder&){;}
public:
   int GetID() { return fID; }
   virtual ~TArtDecoder() {;}
   virtual int Decode(unsigned char* &buffer,const unsigned int &size,
                      TArtMapConfig::TArtMapModules &modules,
                      TArtMapConfig *config) = 0;
   typedef struct {
     unsigned int bits;
     unsigned int shift;
   } mask_t;
   inline unsigned int GetMaskedData32(unsigned int data, mask_t mask);
};
unsigned int TArtDecoder::GetMaskedData32(unsigned int data, mask_t mask)
{
  return (data&mask.bits) >> mask.shift;
}

#endif // end of #ifdef TARTDECODER_H
