/*
 * @file TArtDataSourceFactory.cc
 * @date  Created : 2008/10/30 19:59:23 JST<BR>
 *  Last Modified : 2008/10/30 20:09:41 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtDataSourceFactory.h"
#include "TArtFileDataSource.h"
#include "TArtFileDataSourceGZ.h"
#include "TArtSharedMemoryDataSource.h"
#include <string.h>

TArtDataSourceFactory::TArtDataSourceFactory()
{
}
TArtDataSourceFactory::~TArtDataSourceFactory()
{
}

TArtDataSourceFactory* TArtDataSourceFactory::Instance()
{
   static TArtDataSourceFactory instance;
   return &instance;
}

TArtDataSource* TArtDataSourceFactory::Create(const char *name)
{
  //if (name==0) {
  if (strlen(name)==0) {
    return TArtSharedMemoryDataSource::Instance();
  } else {
    if(!strncmp(name+strlen(name)-3,".gz",3)){
      return TArtFileDataSourceGZ::Instance();
    }else{
      return TArtFileDataSource::Instance();
    }
  }
}

