/*
 * @file TArtConfigFile.cc
 * @date  Created : 2008/10/30 06:43:12 JST<BR>
 *  Last Modified : 2009/01/19 13:29:09 JST
 *--------------------------------------------------------
 *    Comment : 
 *    
 *--------------------------------------------------------
 *    Copyright (C)2008 by Shinsuke OTA <ota@ribf.riken.jp>
 */
#include "TArtConfigFile.h"
#include "TArtCore.h"
#include <stdlib.h>
#include <limits.h>
TArtConfigFile::TArtConfigFile(const char* filename,
                               const char* delim,
                               const char* comment,
                               const char eol)
{
   fDelim = new char[sizeof(delim)];
   fComment = new char[sizeof(comment)];
   fEOL = eol;
   strncpy(fDelim,delim,sizeof(delim));
   strncpy(fComment,comment,sizeof(comment));
   fLast = 0;
   fLine[0] = '\0';
   fFile.open(filename);
   if (!fFile) {
      TArtCore::Info("TArtMapConfig","LoadConfig cannot open file '%s'",filename);
      return;
   }
}
TArtConfigFile::~TArtConfigFile()
{
   if (fFile) fFile.close();
}

const char* TArtConfigFile::GetNextToken()
{
   char *token = fLast;
   if (fLine[0]=='\0' || !fLast || token[0]=='\0' || token[0]==fEOL) {
      fFile.getline(fLine,sizeof(fLine));
      if (fFile.eof()) return 0;
      token = fLine;
   }
   while ((fLast = strpbrk(token,fDelim))) {
      *fLast = '\0';
      fLast++;
      if (strcmp(token,"")) break;
      token = fLast; 
   }
   if (token == fLine && (strpbrk(token,fComment) == token)) {
      fLine[0] = '\0';
      return GetNextToken();
   }
   if (token[0]==fEOL) {
      fLine[0] = '\0';
      return GetNextToken();
   }
//   TArtCore::Info("TArtConfigFile","GetNextToken token = '%s'",token);
   if (token[0]=='\0') return 0;
   return token;
}

int TArtConfigFile::GetNextTokenAsInt(int &lval)
{
   const char* str = GetNextToken();
   char* ret;
   if (!str) return 0;
   lval = strtol(str,&ret,10);
   return (str==ret) ? 0 : 1;
}
