// File for Make the tree file from anapaw.
// Author: Yasuhiro Togano
// 10/05/13

#ifndef MAKETREE_H
#define MAKETREE_H

#include <stdio.h>
#include <vector>

#ifdef __OUTPUT_ROOTFILE__
#include <TFile.h>
#include <TTree.h>
#endif


//#include "TMust2Data.h"
#include "TFocalPlaneData.h"
#include "TPidData.h"
#include "TDaliData.h"

// Common block storing the Focal plane information
extern "C" {
  extern struct {
    float fpdata[12][5][6]; //[nfocus][datatype][nfpdata]
    int lfpdata[12][5][7];
  } focalplanedata_;
}

// Common block storing the MUST2 information
//extern "C" {
//  extern struct{
//    int multinm2[8][4];//[MUST2ID][Dettype]
//    int m2dtype[2304][3];
//    float m2data[8][4][3][128]; //[MUST2ID][Dettype][ID,E,T][mult]
//  } must2conf_;
//}

// Common block storing the run number.
extern "C" {
  extern struct {
    int rnumber;
  } anarunstat_;
}

// Common block storing the device information.
extern "C" {
  extern struct {
    int swihit;
    int swidev[64];
  } analysswitch_;
}

// Common block storing the dali information
extern "C" {
  extern struct {
    int daliid[186];
    float daliinfo[2][186];
    int dalimult;
  } dalidata_;
}

// Common block storing the PPAC, TOF, and AoQ
extern "C"{
  extern struct{
    //float ppacdata[5][5];
    float tofdata[20];
    float aoqdata[20][4];
    int notof;
    int noaoq;
    int trig[16];
    int l_tof[20];
    int l_aoq[20][2];
    //int gatconf;
    //float mm_left_plf7;
    //float mm_left_ppac;
    //float ppacdataf5[5][5];
  } fortree_;
}

extern "C"{
  void open_treefile__(char name[132], int* fnamelen, int* flag);
  void close_treefile__();
  void add_event2tree__();
}

class MakeTree{
private:
#ifdef __OUTPUT_ROOTFILE__
  TFile *fOutFile;
  TTree *t1;
#endif
  bool fIsInitialized;
  static MakeTree *fgMakeTree;
  int fPrevRunNumber;

  //BigRIPS
  TFocalPlaneData*  F3Data;
  TFocalPlaneData*  F5Data;
  TFocalPlaneData*  F7Data;
  TPidData* PIDBigRIPS;
  //ZeroDegree
  TFocalPlaneData*  F8Data;
  TFocalPlaneData*  F9Data;
  TFocalPlaneData* F10Data;
  TFocalPlaneData* F11Data;
  TPidData* PIDZDS;  

  TDaliData* Dali;

  // run rumber
  int tRunNumber;
  
  // event number;
  int tEventNumber;

  int tTrig[16];

public:
  MakeTree();
  ~MakeTree();
  static MakeTree *Instance();
  int Open(const char *filename = 0);

#ifdef __OUTPUT_ROOTGFILE__
  inline TFile* GetOutFilePtr() const {return fOutFile;};
  inline TTree* GetTTreePtr() const {return t1;};
#endif

  void Initialize();
  void BeginOfRun();
  void AddEvent();
  void GetEvent();
  void ClearEvent();
  void Clear();
  void EndOfRun();
};

#endif

