// File for Make the tree file from anapaw.
// Author: Yasuhiro Togano
// LAST UPDATE: 18/10/2010

#include "MakeTree.h"
#include <cstdlib>
#include <sstream>
#include <iostream>

//#include <iostream>

MakeTree *MakeTree::fgMakeTree = 0;

MakeTree::MakeTree()
  : fIsInitialized(false)
{
}

MakeTree::~MakeTree()
{
}

void MakeTree::Initialize(){
  if(fIsInitialized) return;
  fgMakeTree -> ClearEvent();
  fIsInitialized = true;
}

MakeTree* MakeTree::Instance(){
  if(!fgMakeTree) fgMakeTree = new MakeTree();
  return fgMakeTree;
}

// Initialize root file and Tree
void MakeTree::BeginOfRun(){

#if __OUTPUT_ROOTFILE__
  t1 -> Branch("RunNumber",&tRunNumber,"RunNumber/I");
  t1 -> Branch("EventNumber",&tEventNumber,"EventNumber/I");
  t1 -> Branch("Trig",tTrig,"Trig[16]/I");

  // BigRIPS
  if( analysswitch_.swidev[0] == 1){
    F3Data = new TFocalPlaneData();
    t1 -> Branch("F3.",&F3Data);

    F5Data = new TFocalPlaneData();
    t1 -> Branch("F5.",&F5Data);

    F7Data = new TFocalPlaneData();
    t1 -> Branch("F7.",&F7Data);
    
    PIDBigRIPS = new TPidData();
    t1 -> Branch("PIDBigRIPS.",&PIDBigRIPS);
    
  }
  //ZeroDegree
  if( analysswitch_.swidev[1] == 1){
    F8Data = new TFocalPlaneData();
    t1 -> Branch("F8.",&F8Data);

    F9Data = new TFocalPlaneData();
    t1 -> Branch("F9.",&F9Data);

    F10Data = new TFocalPlaneData();
    t1 -> Branch("F10.",&F10Data);

    F11Data = new TFocalPlaneData();
    t1 -> Branch("F11.",&F11Data);

    PIDZDS = new TPidData();
    t1 -> Branch("PIDZDS.",&PIDZDS);
  }

  //DALI
  if(analysswitch_.swidev[20] == 1){
    Dali = new TDaliData();
    t1 -> Branch("Dali.",&Dali);
  }

#endif
}

int MakeTree::Open(const char *filename){
  //Make the root file 
  int ret;

#ifdef __OUTPUT_ROOTFILE__
  fOutFile = new TFile(filename,"RECREATE");
  
  if(fOutFile->IsZombie()){
    ret = 1;
    printf("file open status: ERROR\n");
  }
  else{
    printf("file open status: OK\n");
    t1 = new TTree("t1", filename);
    fgMakeTree -> BeginOfRun();  
    tEventNumber = 0;
    t1 -> SetAutoSave(10000);
    ret = 0;

  }
#else
  printf("Install root before using this routine!\n");
  ret = 1;
#endif

  return ret;

}
  


// Add Events to Root file
void MakeTree::GetEvent(){
  tEventNumber++;
  tRunNumber = anarunstat_.rnumber;

  for(int i=0;i<16;i++){
    tTrig[i] = fortree_.trig[i];
  }
  //BigRIPS data
  if( analysswitch_.swidev[0] == 1){  
    //F3 data ====================================================
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[3][1][i+1] == 1){
	F3Data -> SetPL_DetNum(i+1);
	F3Data -> SetPL_Tcal(focalplanedata_.fpdata[3][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[3][2][0] ==1){
      F3Data -> SetIC_DetNum(1);
      F3Data -> SetIC_Ecal(focalplanedata_.fpdata[3][2][0]);
    }
    
    if(focalplanedata_.lfpdata[3][0][0] == 1){
      F3Data -> SetFP_DetNum(1); 
      F3Data -> SetFP_X(focalplanedata_.fpdata[3][0][0]);
      F3Data -> SetFP_Y(focalplanedata_.fpdata[3][0][1]);
      F3Data -> SetFP_Xdash(focalplanedata_.fpdata[3][0][2]);
      F3Data -> SetFP_Ydash(focalplanedata_.fpdata[3][0][3]);
    }
    if(focalplanedata_.lfpdata[3][1][5] == 1){
      F3Data -> SetFP_PPACT(focalplanedata_.fpdata[3][1][4]);
    }
    
    
    //F5 data ====================================================
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[5][1][i+1] == 1){
	F5Data -> SetPL_DetNum(i+1);
	F5Data -> SetPL_Tcal(focalplanedata_.fpdata[5][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[5][2][0] == 1){
      F5Data -> SetIC_DetNum(1);
      F5Data -> SetIC_Ecal(focalplanedata_.fpdata[5][2][0]);
    }
    // Focal Plane
    
    if(focalplanedata_.lfpdata[5][0][0] == 1){
      F5Data -> SetFP_DetNum(1); 
      F5Data -> SetFP_X(focalplanedata_.fpdata[5][0][0]);
      F5Data -> SetFP_Y(focalplanedata_.fpdata[5][0][1]);
      F5Data -> SetFP_Xdash(focalplanedata_.fpdata[5][0][2]);
      F5Data -> SetFP_Ydash(focalplanedata_.fpdata[5][0][3]);
    }
    if(focalplanedata_.lfpdata[5][1][5] == 1){
      F5Data -> SetFP_PPACT(focalplanedata_.fpdata[5][1][4]);
    }
    
    
    //F7 data ====================================================
    
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[7][1][i+1] == 1){
	F7Data -> SetPL_DetNum(i+1);
	F7Data -> SetPL_Tcal(focalplanedata_.fpdata[7][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[7][2][0] ==1){
      F7Data -> SetIC_DetNum(1);
      F7Data -> SetIC_Ecal(focalplanedata_.fpdata[7][2][0]);
    }
    if(focalplanedata_.lfpdata[7][0][0] == 1){
      F7Data -> SetFP_DetNum(1); 
      F7Data -> SetFP_X(focalplanedata_.fpdata[7][0][0]);
      F7Data -> SetFP_Y(focalplanedata_.fpdata[7][0][1]);
      F7Data -> SetFP_Xdash(focalplanedata_.fpdata[7][0][2]);
      F7Data -> SetFP_Ydash(focalplanedata_.fpdata[7][0][3]);
    }
    if(focalplanedata_.lfpdata[7][1][5] == 1){
      F7Data -> SetFP_PPACT(focalplanedata_.fpdata[7][1][4]);
    }

  //BigRIPS PID ========================================================
    for(int i=0;i<fortree_.notof;i++){
      if(i==0 || i==1 || i==4){
	if(fortree_.l_tof[i] == 1){
	  PIDBigRIPS -> SetTOFID(i);
	  PIDBigRIPS -> SetTOF(fortree_.tofdata[i]);
	}
      }
    }
    
    for(int i=0;i<fortree_.noaoq;i++){
      if(i==0 || i==1 || i==4){
	if(fortree_.l_aoq[i][0] == 1){
	  PIDBigRIPS -> SetAoQID(i);
	  PIDBigRIPS -> SetBrho(fortree_.aoqdata[i][0]);
	  PIDBigRIPS -> SetBeta(fortree_.aoqdata[i][1]);
	  PIDBigRIPS -> SetAoQ(fortree_.aoqdata[i][3]);
	}
	if(fortree_.l_aoq[i][1] == 1){
	  PIDBigRIPS -> SetZ(fortree_.aoqdata[i][2]);
	}
      }
    }
  }
  
  //ZeroDegree
  if( analysswitch_.swidev[1] == 1){  
    //F8 data ====================================================
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[8][1][i+1] == 1){
	F8Data -> SetPL_DetNum(i+1);
	F8Data -> SetPL_Tcal(focalplanedata_.fpdata[8][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[8][2][0] ==1){
      F8Data -> SetIC_DetNum(1);
      F8Data -> SetIC_Ecal(focalplanedata_.fpdata[8][2][0]);
    }
    
    if(focalplanedata_.lfpdata[8][0][0] == 1){
      F8Data -> SetFP_DetNum(1); 
      F8Data -> SetFP_X(focalplanedata_.fpdata[8][0][0]);
      F8Data -> SetFP_Y(focalplanedata_.fpdata[8][0][1]);
      F8Data -> SetFP_Xdash(focalplanedata_.fpdata[8][0][2]);
      F8Data -> SetFP_Ydash(focalplanedata_.fpdata[8][0][3]);
    }
    if(focalplanedata_.lfpdata[8][1][5] == 1){
      F8Data -> SetFP_PPACT(focalplanedata_.fpdata[8][1][4]);
    }
    
    
    //F9 data ====================================================
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[9][1][i+1] == 1){
	F9Data -> SetPL_DetNum(i+1);
	F9Data -> SetPL_Tcal(focalplanedata_.fpdata[9][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[9][2][0] == 1){
      F9Data -> SetIC_DetNum(1);
      F9Data -> SetIC_Ecal(focalplanedata_.fpdata[9][2][0]);
    }
    // Focal Plane
    
    if(focalplanedata_.lfpdata[9][0][0] == 1){
      F9Data -> SetFP_DetNum(1); 
      F9Data -> SetFP_X(focalplanedata_.fpdata[9][0][0]);
      F9Data -> SetFP_Y(focalplanedata_.fpdata[9][0][1]);
      F9Data -> SetFP_Xdash(focalplanedata_.fpdata[9][0][2]);
      F9Data -> SetFP_Ydash(focalplanedata_.fpdata[9][0][3]);
    }
    if(focalplanedata_.lfpdata[9][1][5] == 1){
      F9Data -> SetFP_PPACT(focalplanedata_.fpdata[9][1][4]);
    }
    
    
    //F10 data ====================================================
    
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[10][1][i+1] == 1){
	F10Data -> SetPL_DetNum(i+1);
	F10Data -> SetPL_Tcal(focalplanedata_.fpdata[10][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[10][2][0] ==1){
      F10Data -> SetIC_DetNum(1);
      F10Data -> SetIC_Ecal(focalplanedata_.fpdata[10][2][0]);
    }
    if(focalplanedata_.lfpdata[10][0][0] == 1){
      F10Data -> SetFP_DetNum(1); 
      F10Data -> SetFP_X(focalplanedata_.fpdata[10][0][0]);
      F10Data -> SetFP_Y(focalplanedata_.fpdata[10][0][1]);
      F10Data -> SetFP_Xdash(focalplanedata_.fpdata[10][0][2]);
      F10Data -> SetFP_Ydash(focalplanedata_.fpdata[10][0][3]);
    }
    if(focalplanedata_.lfpdata[10][1][5] == 1){
      F10Data -> SetFP_PPACT(focalplanedata_.fpdata[10][1][4]);
    }

    //F11 data ====================================================
    
    for(int i=0;i<4;i++){
      if(focalplanedata_.lfpdata[11][1][i+1] == 1){
	F11Data -> SetPL_DetNum(i+1);
	F11Data -> SetPL_Tcal(focalplanedata_.fpdata[11][1][i]);
      }
    }
    
    if(focalplanedata_.lfpdata[11][2][0] ==1){
      F11Data -> SetIC_DetNum(1);
      F11Data -> SetIC_Ecal(focalplanedata_.fpdata[11][2][0]);
    }
    if(focalplanedata_.lfpdata[11][0][0] == 1){
      F11Data -> SetFP_DetNum(1); 
      F11Data -> SetFP_X(focalplanedata_.fpdata[11][0][0]);
      F11Data -> SetFP_Y(focalplanedata_.fpdata[11][0][1]);
      F11Data -> SetFP_Xdash(focalplanedata_.fpdata[11][0][2]);
      F11Data -> SetFP_Ydash(focalplanedata_.fpdata[11][0][3]);
    }
    if(focalplanedata_.lfpdata[11][1][5] == 1){
      F11Data -> SetFP_PPACT(focalplanedata_.fpdata[11][1][4]);
    }

  //ZDS PID ========================================================
    for(int i=0;i<fortree_.notof;i++){
      if(i==2 || i==6){
	if(fortree_.l_tof[i] == 1){
	  PIDZDS -> SetTOFID(i);
	  PIDZDS -> SetTOF(fortree_.tofdata[i]);
	}
      }
    }
    
    for(int i=0;i<fortree_.noaoq;i++){
      if(i==2 || i==3 || i==5){
	if(fortree_.l_aoq[i][0] == 1){
	  PIDZDS -> SetAoQID(i);
	  PIDZDS -> SetBrho(fortree_.aoqdata[i][0]);
	  PIDZDS -> SetBeta(fortree_.aoqdata[i][1]);
	  PIDZDS -> SetAoQ(fortree_.aoqdata[i][3]);
	}
	if(fortree_.l_aoq[i][1] == 1){
	  PIDZDS -> SetZ(fortree_.aoqdata[i][2]);
	}
      }
    }
  }

  //DALI
  if(analysswitch_.swidev[20] == 1){
    for(int i=0;i<dalidata_.dalimult;i++){
      Dali -> SetDetID(dalidata_.daliid[i]);
      Dali -> SetEcal(dalidata_.daliinfo[0][i]);
      Dali -> SetTcal(dalidata_.daliinfo[1][i]);
    }
  }


}

void MakeTree::AddEvent(){
  fgMakeTree -> GetEvent();

  // Fill the event to tree
#ifdef __OUTPUT_ROOTFILE__
  t1 -> Fill();
#endif  
  fgMakeTree -> ClearEvent();
}


void MakeTree::ClearEvent(){
  tRunNumber = 0;
  //for(int i=0;i<16;i++){
  //  tTrig[i] = 0;
  //}
  
  //BigRIPS
  if( analysswitch_.swidev[0] == 1){    
    F3Data -> Clear();
    F5Data -> Clear();
    F7Data -> Clear();
    PIDBigRIPS -> Clear();
  }

  //ZeroDegree
  if( analysswitch_.swidev[1] == 1){    
    F8Data -> Clear();
    F9Data -> Clear();
    F10Data -> Clear();
    F11Data -> Clear();
    PIDZDS -> Clear();
  }
  
  if( analysswitch_.swidev[20] == 1){
    Dali -> Clear();
  }


}

void MakeTree::Clear(){
  fIsInitialized = false;
}

 
void MakeTree::EndOfRun(){ 

  if(fOutFile -> IsOpen()){
    t1 -> Print();
    
    t1 -> Write();
    
    fOutFile -> Close();
    
    fgMakeTree -> Clear();
  }
  else{
  }
}
 

//===========================================================================
// for fortran compatible
//===========================================================================
void open_treefile__(char name[132], int* fnamelen, int *flag){
  char filename[256];
  memset(filename, 0, sizeof(filename));
  strncpy(filename, name, *fnamelen);
  
  printf("opening treefile %s\n", name);
  
  MakeTree *make = MakeTree::Instance();
  *flag = make -> Open(filename);
}

void close_treefile__(){
  MakeTree::Instance() -> Initialize();
  MakeTree::Instance() -> EndOfRun();
}

void add_event2tree__(){
  MakeTree::Instance() -> Initialize();
  MakeTree::Instance() -> AddEvent();
}

//===========================================================================
//===========================================================================
